<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Admin\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method workByParams(array $params)
 * @method restByParams(array $params)
 * @method editReplyContentByParams(array $params)
 * @method getWorkStateInfoByParams(array $params)
 */
class StaffWork {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片师工作接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function work () {
        return self::getClass()->work();
    }

    /**
     * 看片师休息接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rest () {
        return self::getClass()->rest();
    }

    /**
     * 看片师更改自动回复语接口
     *
     * @support  string $work_reply_content 工作中回复短语 
     * @support  string $rest_reply_content 休息中回复短语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editReplyContent () {
        return self::getClass()->editReplyContent();
    }

    /**
     * 获取看片师工作状态接口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWorkStateInfo () {
        return self::getClass()->getWorkStateInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Admin\Staff\StaffWork');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Admin\Staff\StaffWork');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}