<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotosByRecordIdByParams(array $params)
 * @method feedbackByParams(array $params)
 * @method satisfiedByParams(array $params)
 * @method submitCropInfoByParams(array $params)
 * @method tagNeedOtherPhotosByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据看片单获取照片信息
     *
     * @param  int $recordId 看片记录id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotosByRecordId (int $recordId) {
        return self::getClass()->getPhotosByRecordId([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 创建反馈
     *
     * @param  int $photoId 照片id [ require true ]
     * @param  int $historyPhotoId 历史照片id [ require true ]
     * @param  array $feedbackRecords 反馈记录 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function feedback (int $photoId, array $feedbackRecords, int $historyPhotoId = NULL) {
        return self::getClass()->feedback([
            "photoId" => $photoId,
            "feedbackRecords" => $feedbackRecords,
            "historyPhotoId" => $historyPhotoId,
        ]);
    }

    /**
     * 照片满意
     *
     * @param  int $id 照片id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function satisfied (int $id) {
        return self::getClass()->satisfied([
            "id" => $id,
        ]);
    }

    /**
     * 提交裁剪信息
     *
     * @param  int $id 照片id [Original type uint] [ require true ]
     * @param  array $cropInfo 裁剪信息 [ require true ]
     * @param  bool $needOtherPhotos 是否需要其他裁剪片 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitCropInfo (int $id, array $cropInfo, bool $needOtherPhotos = false) {
        return self::getClass()->submitCropInfo([
            "id" => $id,
            "cropInfo" => $cropInfo,
            "needOtherPhotos" => $needOtherPhotos,
        ]);
    }

    /**
     * 标记需要其他电子版本
     *
     * @param  int $id 照片id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tagNeedOtherPhotos (int $id) {
        return self::getClass()->tagNeedOtherPhotos([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'SmallProgram\My\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'SmallProgram\My\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}