<?php
namespace Mainto\Bridge\Invokes\ProjectPictureOnline\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addRecordToOrderByParams(array $params)
 * @method closeByParams(array $params)
 */
class WatchRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 为外部订单新增看片单
     *
     * @param  string $outsideNo 外部订单号 [ require true ]
     * @param  int $orgId 机构id [Original type uint] [ require true ]
     * @param  array $photos photos [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addRecordToOrder (string $outsideNo, int $orgId, array $photos) {
        return self::getClass()->addRecordToOrder([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
            "photos" => $photos,
        ]);
    }

    /**
     * 为外部订单新增看片单-v2.0.0
     *
     * @param  string $recordNo 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (string $recordNo) {
        return self::getClass()->close([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPictureOnline', 'Api\WatchRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPictureOnline', 'Api\WatchRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}