<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-22 18:28:30
 */
namespace Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool;

class SearchWatchPhotoPool {
    /**
     * @var  string
     * 看片完成范围查询：开始时间
     * validation: required_without_all:orderNum,userName,phone,photographyStartTime,photographyEndTime|date_format:Y-m-d H:i:s
     */
    public string $watchStartTime;
    /**
     * @var  string
     * 看片完成范围查询：结束时间
     * validation: required_without_all:orderNum,userName,phone,photographyStartTime,photographyEndTime|date_format:Y-m-d H:i:s
     */
    public string $watchEndTime;
    /**
     * @var  string
     * 摄影上传范围查询：开始时间
     * validation: required_without_all:orderNum,userName,phone,watchStartTime,watchEndTime|date_format:Y-m-d H:i:s
     */
    public string $photographyStartTime;
    /**
     * @var  string
     * 摄影上传范围查询：结束时间
     * validation: required_without_all:orderNum,userName,phone,watchStartTime,watchEndTime|date_format:Y-m-d H:i:s
     */
    public string $photographyEndTime;
    /**
     * @var  string
     * 订单号
     * validation: 
     */
    public string $orderNum = "";
    /**
     * @var  string
     * 用户名称
     * validation: 
     */
    public string $userName = "";
    /**
     * @var  string
     * 用户手机号
     * validation: 
     */
    public string $phone = "";
    /**
     * @var  array
     * 看片师ids
     * validation: 
     */
    public array $watcherIds = [];
    /**
     * @var  array
     * 门店ids
     * validation: 
     */
    public array $storeIds = [];
    /**
     * @var  array
     * 产品ids，最大限制2000个
     * validation: 
     */
    public array $productIds = [];
    /**
     * @var  int
     * 页数
     * validation: 
     */
    public int $page = 1;
    /**
     * @var  int
     * 每页数量
     * validation: max:100
     */
    public int $pageSize = 20;
    /**
     * @var  array
     * 看片督导们
     * validation: 
     */
    public array $watcherSuperviseIds = [];
    /**
     * @var  string
     * 照片版本，ORIGINAL:原片，CLOUD_COMPLETE:云端成片，SATISFACTION：顾客满意片
     * validation: 
     */
    public string $photoVersion = "SATISFACTION";
    /**
     * @var  string
     * 看片客片池
     * validation: 
     */
    public string $source = "WATCH_PICTURE_POOL";

    public function __construct (string $watchStartTime = '', string $watchEndTime = '', string $photographyStartTime = '', string $photographyEndTime = '', string $token = '', int $loginStaffId = 0) {
        if (!is_null($watchStartTime)) {
            $this->watchStartTime = $watchStartTime;
        }
        if (!is_null($watchEndTime)) {
            $this->watchEndTime = $watchEndTime;
        }
        if (!is_null($photographyStartTime)) {
            $this->photographyStartTime = $photographyStartTime;
        }
        if (!is_null($photographyEndTime)) {
            $this->photographyEndTime = $photographyEndTime;
        }
        if (!is_null($token)) {
            $this->token = $token;
        }
        if (!is_null($loginStaffId)) {
            $this->loginStaffId = $loginStaffId;
        }
    }

    public static function create(string $watchStartTime = '', string $watchEndTime = '', string $photographyStartTime = '', string $photographyEndTime = '', string $token = '', int $loginStaffId = 0): self {
        return new self($watchStartTime, $watchEndTime, $photographyStartTime, $photographyEndTime, $token, $loginStaffId);
    }

    public function setWatchStartTime(string $watchStartTime): self {
        $this->watchStartTime = $watchStartTime;

        return $this;
    }

    public function setWatchEndTime(string $watchEndTime): self {
        $this->watchEndTime = $watchEndTime;

        return $this;
    }

    public function setPhotographyStartTime(string $photographyStartTime): self {
        $this->photographyStartTime = $photographyStartTime;

        return $this;
    }

    public function setPhotographyEndTime(string $photographyEndTime): self {
        $this->photographyEndTime = $photographyEndTime;

        return $this;
    }

    public function setOrderNum(string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setUserName(string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setPhone(string $phone): self {
        $this->phone = $phone;

        return $this;
    }

    public function setWatcherIds(array $watcherIds): self {
        $this->watcherIds = $watcherIds;

        return $this;
    }

    public function setStoreIds(array $storeIds): self {
        $this->storeIds = $storeIds;

        return $this;
    }

    public function setProductIds(array $productIds): self {
        $this->productIds = $productIds;

        return $this;
    }

    public function setPage(int $page): self {
        $this->page = $page;

        return $this;
    }

    public function setPageSize(int $pageSize): self {
        $this->pageSize = $pageSize;

        return $this;
    }

    public function setWatcherSuperviseIds(array $watcherSuperviseIds): self {
        $this->watcherSuperviseIds = $watcherSuperviseIds;

        return $this;
    }

    public function setPhotoVersion(string $photoVersion): self {
        $this->photoVersion = $photoVersion;

        return $this;
    }

    public function setSource(string $source): self {
        $this->source = $source;

        return $this;
    }
}