<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-20 14:53:02
 */
namespace Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal;

class GetAppeal {
    /**
     * @var  string
     * 评分开始时间
     * validation: date_format:Y-m-d H:i:s
     */
    public string $startAt;
    /**
     * @var  string
     * 评分结束时间
     * validation: date_format:Y-m-d H:i:s
     */
    public string $endAt;
    /**
     * @var  string
     * 订单号
     * validation: 
     */
    public string $cloudOrderNum = "";
    /**
     * @var  string
     * 业务类型
     * validation: 
     */
    public string $serviceType;
    /**
     * @var  array
     * 申诉状态
     * validation: 
     */
    public array $appealStatus = [];
    /**
     * @var  string
     * 申请人
     * validation: 
     */
    public string $inputStaff = "";
    /**
     * @var  array
     * 伙伴ids
     * validation: 
     */
    public array $staffIds = [];
    /**
     * @var  array
     * 督导ids
     * validation: 
     */
    public array $supervisorArr = [];
    /**
     * @var  array
     * 门店id
     * validation: 
     */
    public array $storeIds = [];
    /**
     * @var  int
     * 页码
     * validation: 
     */
    public int $page = 1;
    /**
     * @var  int
     * 每页条数
     * validation: 
     */
    public int $pageSize = 10;

    public function __construct (int $loginStaffId = 0, string $startAt = '', string $endAt = '', string $serviceType = '') {
        if (!is_null($loginStaffId)) {
            $this->loginStaffId = $loginStaffId;
        }
        if (!is_null($startAt)) {
            $this->startAt = $startAt;
        }
        if (!is_null($endAt)) {
            $this->endAt = $endAt;
        }
        if (!is_null($serviceType)) {
            $this->serviceType = $serviceType;
        }
    }

    public static function create(int $loginStaffId = 0, string $startAt = '', string $endAt = '', string $serviceType = ''): self {
        return new self($loginStaffId, $startAt, $endAt, $serviceType);
    }

    public function setStartAt(string $startAt): self {
        $this->startAt = $startAt;

        return $this;
    }

    public function setEndAt(string $endAt): self {
        $this->endAt = $endAt;

        return $this;
    }

    public function setCloudOrderNum(string $cloudOrderNum): self {
        $this->cloudOrderNum = $cloudOrderNum;

        return $this;
    }

    public function setServiceType(string $serviceType): self {
        $this->serviceType = $serviceType;

        return $this;
    }

    public function setAppealStatus(array $appealStatus): self {
        $this->appealStatus = $appealStatus;

        return $this;
    }

    public function setInputStaff(string $inputStaff): self {
        $this->inputStaff = $inputStaff;

        return $this;
    }

    public function setStaffIds(array $staffIds): self {
        $this->staffIds = $staffIds;

        return $this;
    }

    public function setSupervisorArr(array $supervisorArr): self {
        $this->supervisorArr = $supervisorArr;

        return $this;
    }

    public function setStoreIds(array $storeIds): self {
        $this->storeIds = $storeIds;

        return $this;
    }

    public function setPage(int $page): self {
        $this->page = $page;

        return $this;
    }

    public function setPageSize(int $pageSize): self {
        $this->pageSize = $pageSize;

        return $this;
    }
}