<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-15 11:44:45
 */
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Common
 */
class Common {
    private static string $serviceName = "ProjectPhotoQuality";

    private static string $className = "Common";

    /**
     * 获取当前个人信息
     * @return  array
    */
    public static function getSelfInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSelfInfo();
    }
    /**
     * 获取权限信息
     * @return  array
    */
    public static function getAuthority () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthority();
    }
    /**
     * 获取评分配置列表
     * @return  array
    */
    public static function getScoreConfigTree (string $poolName, bool $withTrashed = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreConfigTree(["poolName" => $poolName, "withTrashed" => $withTrashed]);
    }
    /**
     * 根据根节点id获取产品分类树
     * @return  array
    */
    public static function getProductCategoryTree (int $rootId, bool $withProduct = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCategoryTree(["rootId" => $rootId, "withProduct" => $withProduct]);
    }
    /**
     * 获取职位列表
     * @return  array
    */
    public static function getPositions () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPositions();
    }
    /**
     * 根据门店类型获取伙伴数量
     * @return  array
    */
    public static function getAllStoreTotal (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\GetAllStoreTotal $getAllStoreTotal) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreTotal($getAllStoreTotal);
    }
    /**
     * 获取门店小伙伴级联树
     * @return  array
    */
    public static function getStoreStaffList (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\GetStoreStaffList $getStoreStaffList) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreStaffList($getStoreStaffList);
    }
    /**
     * 查询职能组小伙伴
     * @return  array
    */
    public static function searchPositionStaffs (int $positionId, int $ninStaffId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchPositionStaffs(["positionId" => $positionId, "ninStaffId" => $ninStaffId]);
    }
    /**
     * 获取职能组小伙伴树
     * @return  array
    */
    public static function getPositionStaffs (string $type = '', int $staffId = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPositionStaffs(["type" => $type, "staffId" => $staffId]);
    }
    /**
     * 获取全部角色组
     * @return  array
    */
    public static function getAllRole () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllRole();
    }
    /**
     * 获取全部门店
     * @return  array
    */
    public static function getAllStore (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\GetAllStore $getAllStore) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStore($getAllStore);
    }
    /**
     * 获取管辖门店
     * @return  array
    */
    public static function getAreaStore (string $type = 'makeup', array $state = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreaStore(["type" => $type, "state" => $state]);
    }
    /**
     * 获取全部评分人
     * @return  array
    */
    public static function getTakeStaffList (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTakeStaffList(["type" => $type]);
    }
    /**
     * 根据小伙伴昵称或姓名模糊查询小伙伴列表
     * @return  array
    */
    public static function searchStaffByName (string $type = 'makeup', string $nameOrNickname) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStaffByName(["type" => $type, "nameOrNickname" => $nameOrNickname]);
    }
    /**
     * 获取海马体产品
     * @return  array
    */
    public static function getHimoProducts (array $module) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHimoProducts(["module" => $module]);
    }
    /**
     * getItemDetail
     * @return  array
    */
    public static function getItemDetail (string $poolName, string $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getItemDetail(["poolName" => $poolName, "id" => $id]);
    }
    /**
     * 抽片试点
     * @return  bool
    */
    public static function isCheckPoolExperiment () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isCheckPoolExperiment();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}