<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-15 11:43:28
 */
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Role
 */
class Role {
    private static string $serviceName = "ProjectPhotoQuality";

    private static string $className = "Staff\\Role";

    /**
     * 获取角色列表
     * @return  array
    */
    public static function getRoleList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRoleList($_params);
    }
    /**
     * 获取角色详情
     * @return  array
    */
    public static function getRoleInfo (int $roleId, bool $additionInfo = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRoleInfo(["roleId" => $roleId, "additionInfo" => $additionInfo]);
    }
    /**
     * 添加角色
     * @return  int
    */
    public static function addRole (string $title, array $permissionIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRole(["title" => $title, "permissionIds" => $permissionIds]);
    }
    /**
     * 修改角色
     * @return  int
    */
    public static function editRole (string $title, array $permissionIds, int $roleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRole(["title" => $title, "permissionIds" => $permissionIds, "roleId" => $roleId]);
    }
    /**
     * 删除角色
     * @return  bool
    */
    public static function delRole (int $roleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delRole(["roleId" => $roleId]);
    }
    /**
     * 获取所有权限列表
     * @return  array
    */
    public static function getPermissionList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPermissionList();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}