<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-14 18:45:11
 */
namespace Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool;

class GetSearchHistory {
    /**
     * @var  string
     * 开始时间
     * validation: date_format:Y-m-d H:i:s
     */
    public string $startTime;
    /**
     * @var  string
     * 结束时间
     * validation: date_format:Y-m-d H:i:s
     */
    public string $endTime;
    /**
     * @var  array
     * 产品ids
     * validation: 
     */
    public array $productIds = [];
    /**
     * @var  array
     * 海马体产品ids
     * validation: 
     */
    public array $himoProductIds = [];
    /**
     * @var  array
     * 问题标签ids
     * validation: 
     */
    public array $problemTagsIds = [];
    /**
     * @var  array
     * 督导ids, 职能小伙伴
     * validation: 
     */
    public array $supervisorArr = [];
    /**
     * @var  array
     * 伙伴ids
     * validation: 
     */
    public array $staffIds = [];
    /**
     * @var  array
     * 评分分数
     * validation: 
     */
    public array $score = [];
    /**
     * @var  array
     * 
     * validation: 
     */
    public array $storeIds = [];
    /**
     * @var  string
     * 拍摄订单号
     * validation: 
     */
    public string $orderNum = "";
    /**
     * @var  bool
     * 只看新人
     * validation: 
     */
    public bool $onlyNew = false;
    /**
     * @var  bool
     * 只看正式伙伴
     * validation: 
     */
    public bool $onlyOld = false;
    /**
     * @var  null|string
     * 工作模式:单人或者协作
     * validation: 
     */
    public ?string $workForm = null;
    /**
     * @var  bool
     * 
     * validation: 
     */
    public bool $noLabel = false;
    /**
     * @var  int
     * 页数
     * validation: 
     */
    public int $page = 1;
    /**
     * @var  int
     * 每页数量
     * validation: max:100
     */
    public int $pageSize = 10;

    public function __construct (string $startTime = '', string $endTime = '') {
        if (!is_null($startTime)) {
            $this->startTime = $startTime;
        }
        if (!is_null($endTime)) {
            $this->endTime = $endTime;
        }
    }

    public static function create(string $startTime = '', string $endTime = ''): self {
        return new self($startTime, $endTime);
    }

    public function setStartTime(string $startTime): self {
        $this->startTime = $startTime;

        return $this;
    }

    public function setEndTime(string $endTime): self {
        $this->endTime = $endTime;

        return $this;
    }

    public function setProductIds(array $productIds): self {
        $this->productIds = $productIds;

        return $this;
    }

    public function setHimoProductIds(array $himoProductIds): self {
        $this->himoProductIds = $himoProductIds;

        return $this;
    }

    public function setProblemTagsIds(array $problemTagsIds): self {
        $this->problemTagsIds = $problemTagsIds;

        return $this;
    }

    public function setSupervisorArr(array $supervisorArr): self {
        $this->supervisorArr = $supervisorArr;

        return $this;
    }

    public function setStaffIds(array $staffIds): self {
        $this->staffIds = $staffIds;

        return $this;
    }

    public function setScore(array $score): self {
        $this->score = $score;

        return $this;
    }

    public function setStoreIds(array $storeIds): self {
        $this->storeIds = $storeIds;

        return $this;
    }

    public function setOrderNum(string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setOnlyNew(bool $onlyNew): self {
        $this->onlyNew = $onlyNew;

        return $this;
    }

    public function setOnlyOld(bool $onlyOld): self {
        $this->onlyOld = $onlyOld;

        return $this;
    }

    public function setWorkForm(?string $workForm): self {
        $this->workForm = $workForm;

        return $this;
    }

    public function setNoLabel(bool $noLabel): self {
        $this->noLabel = $noLabel;

        return $this;
    }

    public function setPage(int $page): self {
        $this->page = $page;

        return $this;
    }

    public function setPageSize(int $pageSize): self {
        $this->pageSize = $pageSize;

        return $this;
    }
}