<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-15 10:02:32
 */
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class HimoPhotographyPool
 */
class HimoPhotographyPool {
    private static string $serviceName = "ProjectPhotoQuality";

    private static string $className = "CheckPool\\HimoPhotographyPool";

    /**
     * 海马体摄影-抽片
     * @return  string
    */
    public static function takePhoto (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\TakePhoto $takePhoto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->takePhoto($takePhoto);
    }
    /**
     * 海马体摄影-获取是否有未评分的抽片
     * @return  mixed
    */
    public static function getHaveSpotCheckResult (string $workForm) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHaveSpotCheckResult(["workForm" => $workForm]);
    }
    /**
     * 海马体摄影-获取抽片结果列表
     * @return  array
    */
    public static function getSpotCheckResultList (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSpotCheckResultList $getSpotCheckResultList) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpotCheckResultList($getSpotCheckResultList);
    }
    /**
     * 海马体摄影-获取今日抽片指标
     * @return  array
    */
    public static function getTodayEvaluateCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTodayEvaluateCount();
    }
    /**
     * 海马体摄影-获取历史记录
     * @return  array
    */
    public static function getSearchHistory (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $getSearchHistory) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSearchHistory($getSearchHistory);
    }
    /**
     * 海马体摄影-类别配置-添加
     * @return  int
    */
    public static function addScoreType (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addScoreType(["name" => $name]);
    }
    /**
     * 海马体摄影-类别配置-修改
     * @return  int
    */
    public static function editScoreType (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editScoreType(["id" => $id, "name" => $name]);
    }
    /**
     * 海马体摄影-评分配置-获取列表
     * @return  array
    */
    public static function getScoreConfigList (bool $withTrashed = false, bool $isNewConfig = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreConfigList(["withTrashed" => $withTrashed, "isNewConfig" => $isNewConfig]);
    }
    /**
     * 海马体摄影-评分配置-添加
     * @return  int
    */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addScoreConfig(["name" => $name, "children" => $children, "scoreTypeId" => $scoreTypeId]);
    }
    /**
     * 海马体摄影-评分配置-修改
     * @return  int
    */
    public static function editScoreConfig (int $id, string $name, array $children) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editScoreConfig(["id" => $id, "name" => $name, "children" => $children]);
    }
    /**
     * 海马体摄影-评分配置-删除
     * @return  bool
    */
    public static function delScoreConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delScoreConfig(["id" => $id]);
    }
    /**
     * 海马体摄影-清空记录
     * @return  bool
    */
    public static function emptyPoolByStaffId (array $staffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->emptyPoolByStaffId(["staffIds" => $staffIds]);
    }
    /**
     * 海马体摄影-评分配置-获取通用配置
     * @return  array
    */
    public static function getScoreGeneralConfig () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreGeneralConfig();
    }
    /**
     * 海马体摄影-评分配置-新款应用设置
     * @return  bool
    */
    public static function setNewConfig (bool $state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setNewConfig(["state" => $state]);
    }
    /**
     * 海马体摄影-提交评分
     * @return  bool
    */
    public static function commitHistory (array $photos, string $poolItemId, array $tags, int $scaleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->commitHistory(["photos" => $photos, "poolItemId" => $poolItemId, "tags" => $tags, "scaleId" => $scaleId]);
    }
    /**
     * 海马体摄影-修改评分
     * @return  bool
    */
    public static function updateCommitHistory (array $photos, string $poolItemId, array $tags, int $scaleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCommitHistory(["photos" => $photos, "poolItemId" => $poolItemId, "tags" => $tags, "scaleId" => $scaleId]);
    }
    /**
     * 海马体摄影-换一单
     * @return  array
    */
    public static function changeItem (string $poolItemId, string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeItem(["poolItemId" => $poolItemId, "uuid" => $uuid]);
    }
    /**
     * 海马体摄影-跳过伙伴
     * @return  bool
    */
    public static function skipStaff (array $staffIds, string $poolItemId, bool $todayNotExtract = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skipStaff(["staffIds" => $staffIds, "poolItemId" => $poolItemId, "todayNotExtract" => $todayNotExtract]);
    }
    /**
     * 获取质检报告(全员)
     * @return  array
    */
    public static function getAllQualityReport (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $getSearchHistory) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllQualityReport($getSearchHistory);
    }
    /**
     * 获取质检报告(区域)
     * @return  array
    */
    public static function getAreaQualityReport (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $getSearchHistory) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreaQualityReport($getSearchHistory);
    }
    /**
     * 获取质检报告(区域)绩效
     * @return  array
    */
    public static function getAreaQuota (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $getSearchHistory) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAreaQuota($getSearchHistory);
    }
    /**
     * 获取质检报告(全员)绩效
     * @return  array
    */
    public static function getAllQuota (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $getSearchHistory) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllQuota($getSearchHistory);
    }
    /**
     * 删除评分记录并且完成当前批次评分
     * @return  bool
    */
    public static function deleteHistory (string $poolItemId, string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteHistory(["poolItemId" => $poolItemId, "uuid" => $uuid]);
    }
    /**
     * 删除评分
     * @return  bool
    */
    public static function deleteCheckPoolHistory (string $deleteId, string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCheckPoolHistory(["deleteId" => $deleteId, "uuid" => $uuid]);
    }
    /**
     * 抽片进度条
     * @return  mixed
    */
    public static function getProgress (string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProgress(["uuid" => $uuid]);
    }
    /**
     * 获取老评分列表
     * @return  mixed
    */
    public static function getOldScoreConfigList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOldScoreConfigList();
    }
    /**
     * 设置高低分数线
     * @return  bool
    */
    public static function setScoreLines (float $lowScore = null, float $highScore = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setScoreLines(["lowScore" => $lowScore, "highScore" => $highScore]);
    }
    /**
     * 获取高低分数线
     * @return  array
    */
    public static function getScoreLines () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreLines();
    }
    /**
     * 设置评分档位
     * @return  mixed
    */
    public static function setScoreScale (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\ScoreScales $scoreScales) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setScoreScale($scoreScales);
    }
    /**
     * 获取评分档位
     * @return  mixed
    */
    public static function getScoreScale () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreScale();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}