<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-11 18:34:21
 */
namespace Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool;

class Search {
    /**
     * @var  string
     * 开始时间
     * validation: required_without_all:orderNum,userName,phone|date_format:Y-m-d H:i:s
     */
    public string $startTime;
    /**
     * @var  string
     * 结束时间
     * validation: required_without_all:orderNum,userName,phone|date_format:Y-m-d H:i:s
     */
    public string $endTime;
    /**
     * @var  string
     * 订单号
     * validation: 
     */
    public string $orderNum = "";
    /**
     * @var  string
     * 用户名称
     * validation: 
     */
    public string $userName = "";
    /**
     * @var  string
     * 用户手机号
     * validation: 
     */
    public string $phone = "";
    /**
     * @var  array
     * 伙伴ids
     * validation: 
     */
    public array $staffIds = [];
    /**
     * @var  string
     * 类型，伙伴ids不为空时是必填的
     * validation: in:photography,makeup
     */
    public string $type = "";
    /**
     * @var  array
     * 门店ids
     * validation: 
     */
    public array $storeIds = [];
    /**
     * @var  array
     * 产品ids
     * validation: 
     */
    public array $productIds = [];
    /**
     * @var  string
     * 态度
     * validation: in:good,bad,pre_good,pre_bad
     */
    public string $attitude = "";
    /**
     * @var  string
     * 身份
     * validation: in:photography,makeup|required_with:attitude
     */
    public string $opType = "";
    /**
     * @var  int
     * 页数
     * validation: 
     */
    public int $page = 1;
    /**
     * @var  int
     * 每页数量
     * validation: max:100
     */
    public int $pageSize = 10;
    /**
     * @var  array
     * 摄影专家们
     * validation: 
     */
    public array $photographerExpertIds = [];
    /**
     * @var  array
     * 摄影督导们
     * validation: 
     */
    public array $photographerSuperviseIds = [];
    /**
     * @var  array
     * 化妆专家们
     * validation: 
     */
    public array $dresserExpertIds = [];
    /**
     * @var  array
     * 化妆督导们
     * validation: 
     */
    public array $dresserSuperviseIds = [];
    /**
     * @var  array
     * 摄影师
     * validation: 
     */
    public array $photographerIds = [];
    /**
     * @var  array
     * 化妆师
     * validation: 
     */
    public array $dresserIds = [];

    public function __construct (int $loginStaffId = 0, string $startTime = '', string $endTime = '') {
        if (!is_null($loginStaffId)) {
            $this->loginStaffId = $loginStaffId;
        }
        if (!is_null($startTime)) {
            $this->startTime = $startTime;
        }
        if (!is_null($endTime)) {
            $this->endTime = $endTime;
        }
    }

    public static function create(int $loginStaffId = 0, string $startTime = '', string $endTime = ''): self {
        return new self($loginStaffId, $startTime, $endTime);
    }

    public function setStartTime(string $startTime): self {
        $this->startTime = $startTime;

        return $this;
    }

    public function setEndTime(string $endTime): self {
        $this->endTime = $endTime;

        return $this;
    }

    public function setOrderNum(string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setUserName(string $userName): self {
        $this->userName = $userName;

        return $this;
    }

    public function setPhone(string $phone): self {
        $this->phone = $phone;

        return $this;
    }

    public function setStaffIds(array $staffIds): self {
        $this->staffIds = $staffIds;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }

    public function setStoreIds(array $storeIds): self {
        $this->storeIds = $storeIds;

        return $this;
    }

    public function setProductIds(array $productIds): self {
        $this->productIds = $productIds;

        return $this;
    }

    public function setAttitude(string $attitude): self {
        $this->attitude = $attitude;

        return $this;
    }

    public function setOpType(string $opType): self {
        $this->opType = $opType;

        return $this;
    }

    public function setPage(int $page): self {
        $this->page = $page;

        return $this;
    }

    public function setPageSize(int $pageSize): self {
        $this->pageSize = $pageSize;

        return $this;
    }

    public function setPhotographerExpertIds(array $photographerExpertIds): self {
        $this->photographerExpertIds = $photographerExpertIds;

        return $this;
    }

    public function setPhotographerSuperviseIds(array $photographerSuperviseIds): self {
        $this->photographerSuperviseIds = $photographerSuperviseIds;

        return $this;
    }

    public function setDresserExpertIds(array $dresserExpertIds): self {
        $this->dresserExpertIds = $dresserExpertIds;

        return $this;
    }

    public function setDresserSuperviseIds(array $dresserSuperviseIds): self {
        $this->dresserSuperviseIds = $dresserSuperviseIds;

        return $this;
    }

    public function setPhotographerIds(array $photographerIds): self {
        $this->photographerIds = $photographerIds;

        return $this;
    }

    public function setDresserIds(array $dresserIds): self {
        $this->dresserIds = $dresserIds;

        return $this;
    }
}