<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-11 18:51:28
 */
namespace Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality;

class GetAuditRecordTotal {
    /**
     * @var  string
     * 开始时间
     * validation: date_format:Y-m-d H:i:s
     */
    public string $startAt;
    /**
     * @var  string
     * 结束时间
     * validation: date_format:Y-m-d H:i:s
     */
    public string $endAt;
    /**
     * @var  string
     * 订单号
     * validation: 
     */
    public string $cloudOrderNum = "";
    /**
     * @var  array
     * 产品
     * validation: 
     */
    public array $productIds = [];
    /**
     * @var  string
     * AI标签
     * validation: sometimes|in:normal,abnormal,AiRefuse
     */
    public string $auditState = "";
    /**
     * @var  array
     * 督导ids
     * validation: 
     */
    public array $supervisorArr = [];
    /**
     * @var  array
     * 伙伴ids
     * validation: 
     */
    public array $staffIds = [];
    /**
     * @var  array
     * 门店类型
     * validation: 
     */
    public array $storeType;
    /**
     * @var  array
     * 门店ids
     * validation: 
     */
    public array $storeIds = [];
    /**
     * @var  string
     * 拍摄订单号
     * validation: 
     */
    public string $orderNum = "";
    /**
     * @var  bool
     * 只看新人
     * validation: 
     */
    public bool $onlyNew = false;
    /**
     * @var  bool
     * 只看正式伙伴
     * validation: 
     */
    public bool $onlyOld = false;

    public function __construct (int $loginStaffId = 0, string $startAt = '', string $endAt = '', array $storeType = []) {
        if (!is_null($loginStaffId)) {
            $this->loginStaffId = $loginStaffId;
        }
        if (!is_null($startAt)) {
            $this->startAt = $startAt;
        }
        if (!is_null($endAt)) {
            $this->endAt = $endAt;
        }
        if (!is_null($storeType)) {
            $this->storeType = $storeType;
        }
    }

    public static function create(int $loginStaffId = 0, string $startAt = '', string $endAt = '', array $storeType = []): self {
        return new self($loginStaffId, $startAt, $endAt, $storeType);
    }

    public function setStartAt(string $startAt): self {
        $this->startAt = $startAt;

        return $this;
    }

    public function setEndAt(string $endAt): self {
        $this->endAt = $endAt;

        return $this;
    }

    public function setCloudOrderNum(string $cloudOrderNum): self {
        $this->cloudOrderNum = $cloudOrderNum;

        return $this;
    }

    public function setProductIds(array $productIds): self {
        $this->productIds = $productIds;

        return $this;
    }

    public function setAuditState(string $auditState): self {
        $this->auditState = $auditState;

        return $this;
    }

    public function setSupervisorArr(array $supervisorArr): self {
        $this->supervisorArr = $supervisorArr;

        return $this;
    }

    public function setStaffIds(array $staffIds): self {
        $this->staffIds = $staffIds;

        return $this;
    }

    public function setStoreType(array $storeType): self {
        $this->storeType = $storeType;

        return $this;
    }

    public function setStoreIds(array $storeIds): self {
        $this->storeIds = $storeIds;

        return $this;
    }

    public function setOrderNum(string $orderNum): self {
        $this->orderNum = $orderNum;

        return $this;
    }

    public function setOnlyNew(bool $onlyNew): self {
        $this->onlyNew = $onlyNew;

        return $this;
    }

    public function setOnlyOld(bool $onlyOld): self {
        $this->onlyOld = $onlyOld;

        return $this;
    }
}