<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method takePhotoByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\TakePhoto $params)
 * @method getHaveSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultListByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSpotCheckResultList $params)
 * @method getTodayEvaluateCountByParams(array $params)
 * @method getSearchHistoryByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params)
 * @method addScoreTypeByParams(array $params)
 * @method editScoreTypeByParams(array $params)
 * @method getScoreConfigListByParams(array $params)
 * @method addScoreConfigByParams(array $params)
 * @method editScoreConfigByParams(array $params)
 * @method delScoreConfigByParams(array $params)
 * @method emptyPoolByStaffIdByParams(array $params)
 * @method getScoreGeneralConfigByParams(array $params)
 * @method setNewConfigByParams(array $params)
 * @method commitHistoryByParams(array $params)
 * @method updateCommitHistoryByParams(array $params)
 * @method changeItemByParams(array $params)
 * @method skipStaffByParams(array $params)
 * @method getAllQualityReportByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params)
 * @method getAreaQualityReportByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params)
 * @method getAreaQuotaByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params)
 * @method getAllQuotaByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params)
 * @method deleteHistoryByParams(array $params)
 * @method deleteCheckPoolHistoryByParams(array $params)
 * @method getProgressByParams(array $params)
 * @method getOldScoreConfigListByParams(array $params)
 * @method setScoreLinesByParams(array $params)
 * @method getScoreLinesByParams(array $params)
 */
class FamilyMakeupPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Family化妆-抽片
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\TakePhoto $params
     * @throws  \Exception
     * @return  string
     */
    public static function takePhoto (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\TakePhoto $params) {
        return self::getClass()->takePhoto($params);
    }


    /**
     * Family化妆-获取是否有未评分的抽片
     *
     * @param  string $workForm 工作模式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHaveSpotCheckResult (string $workForm) {
        return self::getClass()->getHaveSpotCheckResult([
            "workForm" => $workForm,
        ]);
    }

    /**
     * Family化妆-获取抽片结果列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSpotCheckResultList $params
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResultList (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSpotCheckResultList $params) {
        return self::getClass()->getSpotCheckResultList($params);
    }


    /**
     * Family化妆-获取今日抽片指标
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayEvaluateCount () {
        return self::getClass()->getTodayEvaluateCount();
    }

    /**
     * Family化妆-获取历史记录
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params
     * @throws  \Exception
     * @return  array
     */
    public static function getSearchHistory (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params) {
        return self::getClass()->getSearchHistory($params);
    }


    /**
     * Family化妆-类别配置-添加
     *
     * @param  string $name 评分项名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreType (string $name) {
        return self::getClass()->addScoreType([
            "name" => $name,
        ]);
    }

    /**
     * Family化妆-类别配置-修改
     *
     * @param  int $id 类别id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreType (int $id, string $name) {
        return self::getClass()->editScoreType([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * Family化妆-评分配置-获取列表
     *
     * @param  bool $withTrashed 是否包含删除 [ require false ]
     * @param  bool $isNewConfig 是否显示新款应用 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreConfigList (bool $withTrashed = false, bool $isNewConfig = false) {
        return self::getClass()->getScoreConfigList([
            "withTrashed" => $withTrashed,
            "isNewConfig" => $isNewConfig,
        ]);
    }

    /**
     * Family化妆-评分配置-添加
     *
     * @param  int $scoreTypeId 类别id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return self::getClass()->addScoreConfig([
            "name" => $name,
            "children" => $children,
            "scoreTypeId" => $scoreTypeId,
        ]);
    }

    /**
     * Family化妆-评分配置-修改
     *
     * @param  int $id 评分项id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreConfig (int $id, string $name, array $children) {
        return self::getClass()->editScoreConfig([
            "id" => $id,
            "name" => $name,
            "children" => $children,
        ]);
    }

    /**
     * Family化妆-评分配置-删除
     *
     * @param  int $id 评分项id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delScoreConfig (int $id) {
        return self::getClass()->delScoreConfig([
            "id" => $id,
        ]);
    }

    /**
     * Family化妆-清空记录
     *
     * @param  array $staffIds 小伙伴ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function emptyPoolByStaffId (array $staffIds = []) {
        return self::getClass()->emptyPoolByStaffId([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * Family化妆-评分配置-获取通用配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreGeneralConfig () {
        return self::getClass()->getScoreGeneralConfig();
    }

    /**
     * Family化妆-评分配置-新款应用设置
     *
     * @param  bool $state 开关状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setNewConfig (bool $state) {
        return self::getClass()->setNewConfig([
            "state" => $state,
        ]);
    }

    /**
     * Family摄影-提交评分
     *
     * @support  array $photos 打分明细 [ require true ]
     * @support  string $poolItemId 项目id [ require true ]
     * @support  array $tags 标签信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function commitHistory () {
        return self::getClass()->commitHistory([
        ]);
    }

    /**
     * Family摄影-修改评分
     *
     * @support  array $photos 打分明细 [ require true ]
     * @support  string $poolItemId uuid [ require true ]
     * @support  array $tags 标签 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCommitHistory () {
        return self::getClass()->updateCommitHistory([
        ]);
    }

    /**
     * Family化妆-换一单
     *
     * @param  string $poolItemId 项目id [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeItem (string $poolItemId, string $uuid) {
        return self::getClass()->changeItem([
            "poolItemId" => $poolItemId,
            "uuid" => $uuid,
        ]);
    }

    /**
     * Family化妆-跳过伙伴
     *
     * @support  array $staffIds 不处理的小伙伴id [ require true ]
     * @support  string $poolItemId 项目id [ require true ]
     * @support  bool $todayNotExtract 当天不抽取该伙伴 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function skipStaff () {
        return self::getClass()->skipStaff([
        ]);
    }

    /**
     * 获取质检报告(全员)
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAllQualityReport (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params) {
        return self::getClass()->getAllQualityReport($params);
    }


    /**
     * 获取质检报告(区域)
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaQualityReport (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params) {
        return self::getClass()->getAreaQualityReport($params);
    }


    /**
     * 获取质检报告(区域)绩效
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaQuota (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params) {
        return self::getClass()->getAreaQuota($params);
    }


    /**
     * 获取质检报告(全员)绩效
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAllQuota (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CheckPool\GetSearchHistory $params) {
        return self::getClass()->getAllQuota($params);
    }


    /**
     * 删除评分记录并且完成当前批次评分
     *
     * @param  string $poolItemId 项目id [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteHistory (string $poolItemId, string $uuid) {
        return self::getClass()->deleteHistory([
            "poolItemId" => $poolItemId,
            "uuid" => $uuid,
        ]);
    }

    /**
     * 删除评分
     *
     * @param  string $uuid uuid [ require true ]
     * @param  string $deleteId 项目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteCheckPoolHistory (string $uuid, string $deleteId) {
        return self::getClass()->deleteCheckPoolHistory([
            "uuid" => $uuid,
            "deleteId" => $deleteId,
        ]);
    }

    /**
     * 抽片进度条
     *
     * @param  string $uuid uuid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProgress (string $uuid) {
        return self::getClass()->getProgress([
            "uuid" => $uuid,
        ]);
    }

    /**
     * 获取老评分列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOldScoreConfigList () {
        return self::getClass()->getOldScoreConfigList();
    }

    /**
     * 设置高低分数线
     *
     * @param  float $lowScore 低分 [ require false ]
     * @param  float $highScore 高分 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setScoreLines (float $lowScore = null, float $highScore = null) {
        return self::getClass()->setScoreLines([
            "lowScore" => $lowScore,
            "highScore" => $highScore,
        ]);
    }

    /**
     * 获取高低分数线
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreLines () {
        return self::getClass()->getScoreLines();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CheckPool\FamilyMakeupPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CheckPool\FamilyMakeupPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}