<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CustomerPhotoPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method tagAttitudeSelfByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\TagAttitude $params)
 * @method tagAttitudeByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\TagAttitude $params)
 * @method unTagAttitudeByParams(array $params)
 * @method searchByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\Search $params)
 * @method searchTagAttitudeByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\Search $params)
 * @method detailByParams(array $params)
 * @method getSimilarByImgByParams(array $params)
 * @method getInfoByImgByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标记态度[区域]
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\TagAttitude $tagAttitude
     * @throws  \Exception
     * @return  bool
     */
    public static function tagAttitudeSelf (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\TagAttitude $tagAttitude) {
        return self::getClass()->tagAttitudeSelf($tagAttitude);
    }


    /**
     * 标记态度[全国]
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\TagAttitude $tagAttitude
     * @throws  \Exception
     * @return  bool
     */
    public static function tagAttitude (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\TagAttitude $tagAttitude) {
        return self::getClass()->tagAttitude($tagAttitude);
    }


    /**
     * 取消标记态度
     *
     * @param  string $opType 伙伴身份 [ require true ]
     * @param  string $attitude 态度 [ require true ]
     * @param  int $id 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unTagAttitude (int $id, string $opType, string $attitude) {
        return self::getClass()->unTagAttitude([
            "id" => $id,
            "opType" => $opType,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 搜素[全国]
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\Search $params
     * @throws  \Exception
     * @return  array
     */
    public static function search (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\Search $params) {
        return self::getClass()->search($params);
    }


    /**
     * 搜索标记部分照[区域]
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\Search $params
     * @throws  \Exception
     * @return  array
     */
    public static function searchTagAttitude (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\CustomerPhotoPool\Search $params) {
        return self::getClass()->searchTagAttitude($params);
    }


    /**
     * 详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据当前图片找到相似图片
     *
     * @param  string $imgUrl 当前图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSimilarByImg (string $imgUrl) {
        return self::getClass()->getSimilarByImg([
            "imgUrl" => $imgUrl,
        ]);
    }

    /**
     * 根据当前图片地址找到对应订单
     *
     * @param  string $imgUrl 当前图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfoByImg (string $imgUrl) {
        return self::getClass()->getInfoByImg([
            "imgUrl" => $imgUrl,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CustomerPhotoPool\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CustomerPhotoPool\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}