<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAppealByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\CreateApple $params)
 * @method getAppealByPageByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params)
 * @method getAppealQuotaByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params)
 * @method appealDetailByParams(array $params)
 * @method examineFirstByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\ExamineFirst $params)
 * @method examineSecondByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\ExamineSecond $params)
 * @method getAppealCountByParams(array $params)
 * @method bindFirstByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\BindStaff $params)
 * @method bindSecondByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\BindStaff $params)
 * @method getAppealHistoryByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params)
 */
class FamilyAppeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发起申诉
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\CreateApple $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAppeal (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\CreateApple $params) {
        return self::getClass()->createAppeal($params);
    }


    /**
     * 获取申诉分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAppealByPage (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params) {
        return self::getClass()->getAppealByPage($params);
    }


    /**
     * 获取申诉绩效
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAppealQuota (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params) {
        return self::getClass()->getAppealQuota($params);
    }


    /**
     * 获取申诉详情
     *
     * @param  int $id 申诉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appealDetail (int $id) {
        return self::getClass()->appealDetail([
            "id" => $id,
        ]);
    }

    /**
     * 申诉审核
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\ExamineFirst $params
     * @throws  \Exception
     * @return  bool
     */
    public static function examineFirst (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\ExamineFirst $params) {
        return self::getClass()->examineFirst($params);
    }


    /**
     * 复审
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\ExamineSecond $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function examineSecond (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\ExamineSecond $params) {
        return self::getClass()->examineSecond($params);
    }


    /**
     * 审核总量
     *
     * @param  string $serviceType 业务类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealCount (string $serviceType) {
        return self::getClass()->getAppealCount([
            "serviceType" => $serviceType,
        ]);
    }

    /**
     * 初审绑定
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\BindStaff $params
     * @throws  \Exception
     * @return  bool
     */
    public static function bindFirst (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\BindStaff $params) {
        return self::getClass()->bindFirst($params);
    }


    /**
     * 复审绑定
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\BindStaff $params
     * @throws  \Exception
     * @return  bool
     */
    public static function bindSecond (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\BindStaff $params) {
        return self::getClass()->bindSecond($params);
    }


    /**
     * 获取申诉历史记录
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAppealHistory (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\Appeal\GetAppeal $params) {
        return self::getClass()->getAppealHistory($params);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CheckPool\FamilyAppeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CheckPool\FamilyAppeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}