<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuditRecordTotalByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecordTotal $params)
 * @method getAreaAuditRecordTotalByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecordTotal $params)
 * @method getAuditRecordsByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecord $params)
 * @method getAreaAuditRecordsByParams(array|\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecord $params)
 */
class MakeupPhotoQuality {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 化妆提审记录统计(全员)
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecordTotal $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAuditRecordTotal (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecordTotal $params) {
        return self::getClass()->getAuditRecordTotal($params);
    }


    /**
     * 化妆提审记录统计(区域)
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecordTotal $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaAuditRecordTotal (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecordTotal $params) {
        return self::getClass()->getAreaAuditRecordTotal($params);
    }


    /**
     * 化妆提审记录列表（全员)
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecord $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAuditRecords (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecord $params) {
        return self::getClass()->getAuditRecords($params);
    }


    /**
     * 化妆提审记录列表(区域)
     *
     * @var  \Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecord $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaAuditRecords (\Mainto\Bridge\Structs\ProjectPhotoQuality\Objects\PhotoQuality\GetAuditRecord $params) {
        return self::getClass()->getAreaAuditRecords($params);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'MakeupPhotoQuality');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'MakeupPhotoQuality');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}