<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookCreatedStreamByParams(array $params)
 * @method hookPhotoQualityByParams(array $params)
 * @method hookSyncMakeupByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听云端创建流水
     *
     * @support  array $stream 流水信息 [ require true ]
     * @support  array $photos 照片 [ require true ]
     * @support  array $extends 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCreatedStream () {
        return self::getClass()->hookCreatedStream([
        ]);
    }

    /**
     * 监听照片保存，调用图像算法
     *
     * @support  array $photoIds 照片ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookPhotoQuality () {
        return self::getClass()->hookPhotoQuality([
        ]);
    }

    /**
     * 同步化妆师
     *
     * @param  array $stream_nums 流水ids [ require true ]
     * @param  array $staff_ids 化妆师Id [ require true ]
     * @param  string $pool_type 池子类型 [ require true ]
     * @param  int $org_id 机构id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookSyncMakeup (array $stream_nums, array $staff_ids, string $pool_type, int $org_id) {
        return self::getClass()->hookSyncMakeup([
            "stream_nums" => $stream_nums,
            "staff_ids" => $staff_ids,
            "pool_type" => $pool_type,
            "org_id" => $org_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}