<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CustomerPhotoPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method tagAttitudeSelfByParams(array $params)
 * @method tagAttitudeByParams(array $params)
 * @method unTagAttitudeByParams(array $params)
 * @method searchByParams(array|Photo\Search\Search $params)
 * @method searchTagAttitudeByParams(array|Photo\SearchTagAttitude\Search $params)
 * @method detailByParams(array $params)
 * @method getSimilarByImgByParams(array $params)
 * @method getInfoByImgByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标记态度[区域]
     *
     * @param  string $opType 伙伴身份 [ require true ]
     * @param  string $attitude 态度 [ require true ]
     * @param  int $id 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function tagAttitudeSelf (int $id, string $opType, string $attitude) {
        return self::getClass()->tagAttitudeSelf([
            "id" => $id,
            "opType" => $opType,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 标记态度[全国]
     *
     * @param  string $opType 伙伴身份 [ require true ]
     * @param  string $attitude 态度 [ require true ]
     * @param  int $id 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function tagAttitude (int $id, string $opType, string $attitude) {
        return self::getClass()->tagAttitude([
            "id" => $id,
            "opType" => $opType,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 取消标记态度
     *
     * @param  string $opType 伙伴身份 [ require true ]
     * @param  string $attitude 态度 [ require true ]
     * @param  int $id 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unTagAttitude (int $id, string $opType, string $attitude) {
        return self::getClass()->unTagAttitude([
            "id" => $id,
            "opType" => $opType,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 搜素[全国]
     *
     * @var  Photo\Search\Search $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function search (Photo\Search\Search $params) {
        return self::getClass()->search($params);
    }


    /**
     * 搜索标记部分照[区域]
     *
     * @var  Photo\SearchTagAttitude\Search $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function searchTagAttitude (Photo\SearchTagAttitude\Search $params) {
        return self::getClass()->searchTagAttitude($params);
    }


    /**
     * 详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据当前图片找到相似图片
     *
     * @param  string $imgUrl 当前图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSimilarByImg (string $imgUrl) {
        return self::getClass()->getSimilarByImg([
            "imgUrl" => $imgUrl,
        ]);
    }

    /**
     * 根据当前图片地址找到对应订单
     *
     * @param  string $imgUrl 当前图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfoByImg (string $imgUrl) {
        return self::getClass()->getInfoByImg([
            "imgUrl" => $imgUrl,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CustomerPhotoPool\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CustomerPhotoPool\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}