<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSelfInfoByParams(array $params)
 * @method getAuthorityByParams(array $params)
 * @method getScoreConfigTreeByParams(array $params)
 * @method getProductCategoryTreeByParams(array $params)
 * @method getPositionsByParams(array $params)
 * @method getAllStoreTotalByParams(array $params)
 * @method getStoreStaffListByParams(array $params)
 * @method searchPositionStaffsByParams(array $params)
 * @method getPositionStaffsByParams(array $params)
 * @method getAllRoleByParams(array $params)
 * @method getAllStoreByParams(array $params)
 * @method getAreaStoreByParams(array $params)
 * @method getTakeStaffListByParams(array $params)
 * @method searchStaffByNameByParams(array $params)
 * @method getHimoProductsByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前个人信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfInfo () {
        return self::getClass()->getSelfInfo();
    }

    /**
     * 获取权限信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAuthority () {
        return self::getClass()->getAuthority();
    }

    /**
     * 获取评分配置列表
     *
     * @param  string $poolName 类型:himo_makeup_pool|himo_photography_pool|family_makeup_pool|family_photography_pool [ require true ]
     * @param  bool $withTrashed 是否包含删除 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreConfigTree (string $poolName, bool $withTrashed = false) {
        return self::getClass()->getScoreConfigTree([
            "poolName" => $poolName,
            "withTrashed" => $withTrashed,
        ]);
    }

    /**
     * 根据根节点id获取产品分类树
     *
     * @param  int $rootId 根分类节点id，获取整树所有则传0 [ require true ]
     * @param  bool $withProduct 是否需要产品列表,默认为false [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCategoryTree (int $rootId, bool $withProduct = false) {
        return self::getClass()->getProductCategoryTree([
            "rootId" => $rootId,
            "withProduct" => $withProduct,
        ]);
    }

    /**
     * 获取职位列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPositions () {
        return self::getClass()->getPositions();
    }

    /**
     * 根据门店类型获取伙伴数量
     *
     * @param  array $state 门店类型 [ require true ]
     * @param  string $type 类型:makeup|photography [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStoreTotal (array $state, string $type = 'makeup') {
        return self::getClass()->getAllStoreTotal([
            "state" => $state,
            "type" => $type,
        ]);
    }

    /**
     * 获取门店小伙伴级联树
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @param  string $type 类型:makeup|photography [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreStaffList (array $storeIds, string $type = 'makeup') {
        return self::getClass()->getStoreStaffList([
            "storeIds" => $storeIds,
            "type" => $type,
        ]);
    }

    /**
     * 查询职能组小伙伴
     *
     * @param  int $positionId 身份id [ require true ]
     * @param  int $ninStaffId 排除小伙伴id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchPositionStaffs (int $positionId, int $ninStaffId = 0) {
        return self::getClass()->searchPositionStaffs([
            "positionId" => $positionId,
            "ninStaffId" => $ninStaffId,
        ]);
    }

    /**
     * 获取职能组小伙伴树
     *
     * @param  string $type 类型:makeup|photography [ require true ]
     * @param  int $staffId 小伙伴id, 只出该小伙伴对应的职能组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPositionStaffs (string $type = '', int $staffId = null) {
        return self::getClass()->getPositionStaffs([
            "type" => $type,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取全部角色组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllRole () {
        return self::getClass()->getAllRole();
    }

    /**
     * 获取全部门店
     *
     * @param  array $state 门店类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStore (array $state = []) {
        return self::getClass()->getAllStore([
            "state" => $state,
        ]);
    }

    /**
     * 获取管辖门店
     *
     * @param  array $state 门店类型 [ require true ]
     * @param  string $type 类型:makeup|photography [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaStore (string $type = 'makeup', array $state = []) {
        return self::getClass()->getAreaStore([
            "type" => $type,
            "state" => $state,
        ]);
    }

    /**
     * 获取全部评分人
     *
     * @param  string $type 评分人类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTakeStaffList (string $type) {
        return self::getClass()->getTakeStaffList([
            "type" => $type,
        ]);
    }

    /**
     * 根据小伙伴昵称或姓名模糊查询小伙伴列表
     *
     * @param  string $type 评分人类型 [ require true ]
     * @param  string $nameOrNickname 搜索伙伴姓名/花名, 名字前后需要带上 %纳威%, 为双向模糊查询 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchStaffByName (string $type = 'makeup', string $nameOrNickname) {
        return self::getClass()->searchStaffByName([
            "type" => $type,
            "nameOrNickname" => $nameOrNickname,
        ]);
    }

    /**
     * 获取海马体产品
     *
     * @param  array $module 所属模块 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHimoProducts (array $module) {
        return self::getClass()->getHimoProducts([
            "module" => $module,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}