<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CustomerPhotoPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method tagAttitudeByParams(array $params)
 * @method unTagAttitudeByParams(array $params)
 * @method searchByParams(array $params)
 * @method searchTagAttitudeByParams(array $params)
 * @method getSimilarByImgByParams(array $params)
 * @method getInfoByImgByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标记态度
     *
     * @param  string $attitude 态度 [ require true ]
     * @param  int $id 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function tagAttitude (int $id, string $attitude) {
        return self::getClass()->tagAttitude([
            "id" => $id,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 取消标记态度
     *
     * @param  string $attitude 态度 [ require true ]
     * @param  int $id 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unTagAttitude (int $id, string $attitude) {
        return self::getClass()->unTagAttitude([
            "id" => $id,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 搜素【所有人员可见】
     *
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  string $orderNum 订单号 require false
     * @support  string $userName 姓名 require false
     * @support  string $phone 手机号 require false
     * @support  array $storeIds 门店id require false
     * @support  array $productIds 产品ids require false
     * @support  array $photographerIds 摄影师s require false
     * @support  array $photographerSuperviseIds 摄影督导s require false
     * @support  array $photographerExpertIds 摄影专家s require false
     * @support  array $dresserIds 化妆师ids require false
     * @support  array $dresserSuperviseIds 化妆督导ids require false
     * @support  array $dresserExpertIds 化妆专家Ids require false
     * @support  string $attitude 态度 require false
     * @support  string $opType 身份 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 0, int $pageSize = 10) {
        return self::getClass()->search([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 搜索标记部分照片【包含内部规则】
     *
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  string $orderNum 订单号 require false
     * @support  string $userName 姓名 require false
     * @support  string $phone 手机号 require false
     * @support  array $storeIds 门店id require false
     * @support  array $productIds 产品ids require false
     * @support  array $photographerIds 摄影师s require false
     * @support  array $photographerSuperviseIds 摄影督导s require false
     * @support  array $photographerExpertIds 摄影专家s require false
     * @support  array $dresserIds 化妆师ids require false
     * @support  array $dresserSuperviseIds 化妆督导ids require false
     * @support  array $dresserExpertIds 化妆专家Ids require false
     * @support  string $attitude 态度 require false
     * @support  string $opType 身份 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchTagAttitude (int $page = 0, int $pageSize = 10) {
        return self::getClass()->searchTagAttitude([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据当前图片找到相似图片
     *
     * @param  string $imgUrl 当前图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSimilarByImg (string $imgUrl) {
        return self::getClass()->getSimilarByImg([
            "imgUrl" => $imgUrl,
        ]);
    }

    /**
     * 根据当前图片地址找到对应订单
     *
     * @param  string $imgUrl 当前图片地址 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfoByImg (string $imgUrl) {
        return self::getClass()->getInfoByImg([
            "imgUrl" => $imgUrl,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CustomerPhotoPool\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CustomerPhotoPool\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}