<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getServiceStaffsByParams(array $params)
 * @method getAttitudeByIdentityByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提供外部获取督导专家相关信息
     *
     * @param  int $storeId 记录id [ require true ]
     * @param  array $dressers 化妆师s [ require true ]
     * @param  array $photographers 摄影师s [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getServiceStaffs (int $storeId, array $dressers = [], array $photographers = []) {
        return self::getClass()->getServiceStaffs([
            "storeId" => $storeId,
            "dressers" => $dressers,
            "photographers" => $photographers,
        ]);
    }

    /**
     * 获取客片池评价标记及opType
     *
     * @param  int $staffId 小伙伴id [ require true ]
     * @param  string $attitude 态度【赞，踩, 无】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAttitudeByIdentity (int $staffId, string $attitude) {
        return self::getClass()->getAttitudeByIdentity([
            "staffId" => $staffId,
            "attitude" => $attitude,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Api\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Api\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}