<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuditRecordTotalByParams(array|PhotographyPhotoQuality\GetAuditRecordTotal\GetAuditRecordTotal $params)
 * @method getAreaAuditRecordTotalByParams(array|PhotographyPhotoQuality\GetAreaAuditRecordTotal\GetAuditRecordTotal $params)
 * @method getAuditRecordsByParams(array|PhotographyPhotoQuality\GetAuditRecords\GetAuditRecord $params)
 * @method getAreaAuditRecordsByParams(array|PhotographyPhotoQuality\GetAreaAuditRecords\GetAuditRecord $params)
 */
class PhotographyPhotoQuality {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 摄影提审记录统计
     *
     * @var  PhotographyPhotoQuality\GetAuditRecordTotal\GetAuditRecordTotal $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAuditRecordTotal (PhotographyPhotoQuality\GetAuditRecordTotal\GetAuditRecordTotal $params) {
        return self::getClass()->getAuditRecordTotal($params);
    }


    /**
     * 摄影提审记录统计
     *
     * @var  PhotographyPhotoQuality\GetAreaAuditRecordTotal\GetAuditRecordTotal $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaAuditRecordTotal (PhotographyPhotoQuality\GetAreaAuditRecordTotal\GetAuditRecordTotal $params) {
        return self::getClass()->getAreaAuditRecordTotal($params);
    }


    /**
     * 摄影提审记录列表
     *
     * @var  PhotographyPhotoQuality\GetAuditRecords\GetAuditRecord $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAuditRecords (PhotographyPhotoQuality\GetAuditRecords\GetAuditRecord $params) {
        return self::getClass()->getAuditRecords($params);
    }


    /**
     * 摄影提审记录列表(区域)
     *
     * @var  PhotographyPhotoQuality\GetAreaAuditRecords\GetAuditRecord $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaAuditRecords (PhotographyPhotoQuality\GetAreaAuditRecords\GetAuditRecord $params) {
        return self::getClass()->getAreaAuditRecords($params);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'PhotographyPhotoQuality');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'PhotographyPhotoQuality');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}