<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAppealByParams(array|HimoAppeal\CreateAppeal\CreateApple $params)
 * @method getAppealByPageByParams(array|HimoAppeal\GetAppealByPage\GetAppeal $params)
 * @method getAppealQuotaByParams(array|HimoAppeal\GetAppealQuota\GetAppeal $params)
 * @method appealDetailByParams(array $params)
 * @method examineFirstByParams(array|HimoAppeal\ExamineFirst\ExamineFirst $params)
 * @method examineSecondByParams(array|HimoAppeal\ExamineSecond\ExamineSecond $params)
 * @method getAppealCountByParams(array $params)
 * @method bindFirstByParams(array|HimoAppeal\BindFirst\BindStaff $params)
 * @method bindSecondByParams(array|HimoAppeal\BindSecond\BindStaff $params)
 * @method getAppealHistoryByParams(array|HimoAppeal\GetAppealHistory\GetAppeal $params)
 */
class HimoAppeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发起申诉
     *
     * @var  HimoAppeal\CreateAppeal\CreateApple $params $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAppeal (HimoAppeal\CreateAppeal\CreateApple $params) {
        return self::getClass()->createAppeal($params);
    }


    /**
     * 获取申诉分页
     *
     * @var  HimoAppeal\GetAppealByPage\GetAppeal $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAppealByPage (HimoAppeal\GetAppealByPage\GetAppeal $params) {
        return self::getClass()->getAppealByPage($params);
    }


    /**
     * 获取申诉绩效
     *
     * @var  HimoAppeal\GetAppealQuota\GetAppeal $params $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealQuota (HimoAppeal\GetAppealQuota\GetAppeal $params) {
        return self::getClass()->getAppealQuota($params);
    }


    /**
     * 获取申诉详情
     *
     * @param  int $id 申诉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appealDetail (int $id) {
        return self::getClass()->appealDetail([
            "id" => $id,
        ]);
    }

    /**
     * 申诉审核
     *
     * @var  HimoAppeal\ExamineFirst\ExamineFirst $params $params
     * @throws  \Exception
     * @return  bool
     */
    public static function examineFirst (HimoAppeal\ExamineFirst\ExamineFirst $params) {
        return self::getClass()->examineFirst($params);
    }


    /**
     * 复审
     *
     * @var  HimoAppeal\ExamineSecond\ExamineSecond $params $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function examineSecond (HimoAppeal\ExamineSecond\ExamineSecond $params) {
        return self::getClass()->examineSecond($params);
    }


    /**
     * 审核总量
     *
     * @param  string $serviceType 业务类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealCount (string $serviceType) {
        return self::getClass()->getAppealCount([
            "serviceType" => $serviceType,
        ]);
    }

    /**
     * 初审绑定
     *
     * @var  HimoAppeal\BindFirst\BindStaff $params $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindFirst (HimoAppeal\BindFirst\BindStaff $params) {
        return self::getClass()->bindFirst($params);
    }


    /**
     * 复审绑定
     *
     * @var  HimoAppeal\BindSecond\BindStaff $params $params
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindSecond (HimoAppeal\BindSecond\BindStaff $params) {
        return self::getClass()->bindSecond($params);
    }


    /**
     * 获取申诉历史记录
     *
     * @var  HimoAppeal\GetAppealHistory\GetAppeal $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAppealHistory (HimoAppeal\GetAppealHistory\GetAppeal $params) {
        return self::getClass()->getAppealHistory($params);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CheckPool\HimoAppeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CheckPool\HimoAppeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}