<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method takePhotoByParams(array|HimoPhotographyPool\TakePhoto\TakePhoto $params)
 * @method getHaveSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultListByParams(array|HimoPhotographyPool\GetSpotCheckResultList\GetSpotCheckResultList $params)
 * @method getTodayEvaluateCountByParams(array $params)
 * @method getSearchHistoryByParams(array|HimoPhotographyPool\GetSearchHistory\GetSearchHistory $params)
 * @method addScoreTypeByParams(array $params)
 * @method editScoreTypeByParams(array $params)
 * @method getScoreConfigListByParams(array $params)
 * @method addScoreConfigByParams(array $params)
 * @method editScoreConfigByParams(array $params)
 * @method delScoreConfigByParams(array $params)
 * @method emptyPoolByStaffIdByParams(array $params)
 * @method getScoreGeneralConfigByParams(array $params)
 * @method setNewConfigByParams(array $params)
 * @method commitHistoryByParams(array $params)
 * @method updateCommitHistoryByParams(array $params)
 * @method changeItemByParams(array $params)
 * @method skipStaffByParams(array $params)
 * @method getAllQualityReportByParams(array|HimoPhotographyPool\GetAllQualityReport\GetSearchHistory $params)
 * @method getAreaQualityReportByParams(array|HimoPhotographyPool\GetAreaQualityReport\GetSearchHistory $params)
 * @method getAreaQuotaByParams(array|HimoPhotographyPool\GetAreaQuota\GetSearchHistory $params)
 * @method getAllQuotaByParams(array|HimoPhotographyPool\GetAllQuota\GetSearchHistory $params)
 * @method deleteHistoryByParams(array $params)
 * @method getProgressByParams(array $params)
 * @method getOldScoreConfigListByParams(array $params)
 */
class HimoPhotographyPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 海马体摄影-抽片
     *
     * @var  HimoPhotographyPool\TakePhoto\TakePhoto $params $params
     * @throws  \Exception
     * @return  string
     */
    public static function takePhoto (HimoPhotographyPool\TakePhoto\TakePhoto $params) {
        return self::getClass()->takePhoto($params);
    }


    /**
     * 海马体摄影-获取是否有未评分的抽片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHaveSpotCheckResult () {
        return self::getClass()->getHaveSpotCheckResult();
    }

    /**
     * 海马体摄影-获取抽片结果列表
     *
     * @var  HimoPhotographyPool\GetSpotCheckResultList\GetSpotCheckResultList $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResultList (HimoPhotographyPool\GetSpotCheckResultList\GetSpotCheckResultList $params) {
        return self::getClass()->getSpotCheckResultList($params);
    }


    /**
     * 海马体摄影-获取今日抽片指标
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayEvaluateCount () {
        return self::getClass()->getTodayEvaluateCount();
    }

    /**
     * 海马体摄影-获取历史记录
     *
     * @var  HimoPhotographyPool\GetSearchHistory\GetSearchHistory $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getSearchHistory (HimoPhotographyPool\GetSearchHistory\GetSearchHistory $params) {
        return self::getClass()->getSearchHistory($params);
    }


    /**
     * 海马体摄影-类别配置-添加
     *
     * @param  string $name 评分项名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreType (string $name) {
        return self::getClass()->addScoreType([
            "name" => $name,
        ]);
    }

    /**
     * 海马体摄影-类别配置-修改
     *
     * @param  int $id 类别id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreType (int $id, string $name) {
        return self::getClass()->editScoreType([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 海马体摄影-评分配置-获取列表
     *
     * @param  bool $withTrashed 是否包含删除 [ require true ]
     * @param  bool $isNewConfig 是否显示新款应用 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreConfigList (bool $withTrashed = false, bool $isNewConfig = false) {
        return self::getClass()->getScoreConfigList([
            "withTrashed" => $withTrashed,
            "isNewConfig" => $isNewConfig,
        ]);
    }

    /**
     * 海马体摄影-评分配置-添加
     *
     * @param  int $scoreTypeId 类别id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return self::getClass()->addScoreConfig([
            "name" => $name,
            "children" => $children,
            "scoreTypeId" => $scoreTypeId,
        ]);
    }

    /**
     * 海马体摄影-评分配置-修改
     *
     * @param  int $id 评分项id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreConfig (int $id, string $name, array $children) {
        return self::getClass()->editScoreConfig([
            "id" => $id,
            "name" => $name,
            "children" => $children,
        ]);
    }

    /**
     * 海马体摄影-评分配置-删除
     *
     * @param  int $id 评分项id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delScoreConfig (int $id) {
        return self::getClass()->delScoreConfig([
            "id" => $id,
        ]);
    }

    /**
     * 海马体摄影-清空记录
     *
     * @param  array $staffIds 小伙伴ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function emptyPoolByStaffId (array $staffIds = []) {
        return self::getClass()->emptyPoolByStaffId([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 海马体摄影-评分配置-获取通用配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreGeneralConfig () {
        return self::getClass()->getScoreGeneralConfig();
    }

    /**
     * 海马体摄影-评分配置-新款应用设置
     *
     * @param  bool $state 开关状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setNewConfig (bool $state) {
        return self::getClass()->setNewConfig([
            "state" => $state,
        ]);
    }

    /**
     * 海马体摄影-提交评分
     *
     * @support  array $photos 打分明细 [ require true ]
     * @support  string $poolItemId 项目id [ require true ]
     * @support  array $tags 标签信息 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function commitHistory () {
        return self::getClass()->commitHistory();
    }

    /**
     * 海马体摄影-修改评分
     *
     * @support  array $photos 打分明细 [ require true ]
     * @support  string $poolItemId 项目id [ require true ]
     * @support  array $tags 标签 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCommitHistory () {
        return self::getClass()->updateCommitHistory();
    }

    /**
     * 海马体摄影-换一单
     *
     * @param  string $poolItemId poolItemId [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeItem (string $poolItemId, string $uuid) {
        return self::getClass()->changeItem([
            "poolItemId" => $poolItemId,
            "uuid" => $uuid,
        ]);
    }

    /**
     * 海马体摄影-跳过伙伴
     *
     * @support  array $staffIds 不处理的小伙伴id [ require true ]
     * @support  string $poolItemId 项目id [ require true ]
     * @support  bool $todayNotExtract 当天不抽取该伙伴 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function skipStaff () {
        return self::getClass()->skipStaff();
    }

    /**
     * 获取质检报告(全员)
     *
     * @var  HimoPhotographyPool\GetAllQualityReport\GetSearchHistory $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAllQualityReport (HimoPhotographyPool\GetAllQualityReport\GetSearchHistory $params) {
        return self::getClass()->getAllQualityReport($params);
    }


    /**
     * 获取质检报告(区域)
     *
     * @var  HimoPhotographyPool\GetAreaQualityReport\GetSearchHistory $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaQualityReport (HimoPhotographyPool\GetAreaQualityReport\GetSearchHistory $params) {
        return self::getClass()->getAreaQualityReport($params);
    }


    /**
     * 获取质检报告(区域)绩效
     *
     * @var  HimoPhotographyPool\GetAreaQuota\GetSearchHistory $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaQuota (HimoPhotographyPool\GetAreaQuota\GetSearchHistory $params) {
        return self::getClass()->getAreaQuota($params);
    }


    /**
     * 获取质检报告(全员)绩效
     *
     * @var  HimoPhotographyPool\GetAllQuota\GetSearchHistory $params $params
     * @throws  \Exception
     * @return  array
     */
    public static function getAllQuota (HimoPhotographyPool\GetAllQuota\GetSearchHistory $params) {
        return self::getClass()->getAllQuota($params);
    }


    /**
     * 删除项目
     *
     * @param  string $poolItemId 项目id [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteHistory (string $poolItemId, string $uuid) {
        return self::getClass()->deleteHistory([
            "poolItemId" => $poolItemId,
            "uuid" => $uuid,
        ]);
    }

    /**
     * 抽片进度条
     *
     * @param  string $uuid uuid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProgress (string $uuid) {
        return self::getClass()->getProgress([
            "uuid" => $uuid,
        ]);
    }

    /**
     * 获取老评分列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOldScoreConfigList () {
        return self::getClass()->getOldScoreConfigList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CheckPool\HimoPhotographyPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CheckPool\HimoPhotographyPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}