<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuditRecordTotalByParams(array $params)
 * @method getAreaAuditRecordTotalByParams(array $params)
 * @method getAuditRecordsByParams(array $params)
 * @method getAreaAuditRecordsByParams(array $params)
 */
class MakeupPhotoQuality {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 化妆提审记录统计(全员)
     *
     * @support  string $startAt 评分开始时间 require false
     * @support  string $endAt 评分开始时间 require false
     * @support  string $cloudOrderNum 订单号 require false
     * @support  array $productIds 产品 require false
     * @support  string $auditState AI标签:normal|abnormal require false
     * @support  array $supervisorArr 督导ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $storeType 门店类型: blue||gole||master等 require false
     * @support  string $orderNum 拍摄订单号 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAuditRecordTotal () {
        return self::getClass()->getAuditRecordTotal();
    }

    /**
     * 化妆提审记录统计(区域)
     *
     * @support  string $startAt 评分开始时间 require false
     * @support  string $endAt 评分开始时间 require false
     * @support  string $cloudOrderNum 订单号 require false
     * @support  array $productIds 产品 require false
     * @support  string $auditState AI标签:normal|abnormal require false
     * @support  array $supervisorArr 督导ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $storeType 门店类型: blue||gole||master等 require false
     * @support  string $orderNum 拍摄订单号 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaAuditRecordTotal () {
        return self::getClass()->getAreaAuditRecordTotal();
    }

    /**
     * 化妆提审记录列表（全员)
     *
     * @support  string $startAt 评分开始时间 require false
     * @support  string $endAt 评分开始时间 require false
     * @support  string $cloudOrderNum 订单号 require false
     * @support  array $productIds 产品 require false
     * @support  string $auditState AI标签:normal|abnormal require false
     * @param  int $pageSize  [ require true ]
     * @param  int $page  [ require true ]
     * @support  array $supervisorArr 督导ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $storeType 门店类型: blue||gole||master等 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAuditRecords (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAuditRecords([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 化妆提审记录列表(区域)
     *
     * @support  string $startAt 评分开始时间 require false
     * @support  string $endAt 评分开始时间 require false
     * @support  string $cloudOrderNum 订单号 require false
     * @support  array $productIds 产品 require false
     * @support  string $auditState AI标签:normal|abnormal require false
     * @param  int $pageSize  [ require true ]
     * @param  int $page  [ require true ]
     * @support  array $supervisorArr 督导ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $productIds 产品ids require false
     * @support  array $storeType 门店类型: blue||gole||master等 require false
     * @support  string $orderNum 拍摄订单号 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAreaAuditRecords (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAreaAuditRecords([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'MakeupPhotoQuality');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'MakeupPhotoQuality');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}