<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAppealByParams(array $params)
 * @method getAppealByPageByParams(array $params)
 * @method appealDetailByParams(array $params)
 * @method examineFirstByParams(array $params)
 * @method examineSecondByParams(array $params)
 */
class HimoAppeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发起申诉
     *
     * @support  string $serviceType 业务类型 require false
     * @support  string $serviceId 业务唯一id,例如订单id [ require true ]
     * @support  array $appealContent 申诉内容 [ require true ]
     * @support  string $note 申诉备注 require false
     * @support  string $remark 问题标签申述备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAppeal () {
        return self::getClass()->createAppeal();
    }

    /**
     * 获取申诉分页
     *
     * @support  string $serviceType 业务类型 require false
     * @support  string $appealStatus 申诉状态 require false
     * @support  array $inputStaffIds 申请人ids require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getAppealByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取申诉详情
     *
     * @param  int $id 申诉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appealDetail (int $id) {
        return self::getClass()->appealDetail([
            "id" => $id,
        ]);
    }

    /**
     * 申诉审核
     *
     * @param  int $id 申诉id [ require true ]
     * @param  string $result 审核结果 [ require true ]
     * @param  string $note 问题标签申述备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function examineFirst (int $id, string $result, string $note = 'note') {
        return self::getClass()->examineFirst([
            "id" => $id,
            "result" => $result,
            "note" => $note,
        ]);
    }

    /**
     * 复审
     *
     * @support  int $appealId 申诉id [ require true ]
     * @support  string $poolName 池名称 [ require true ]
     * @support  string $recordId 评价记录id [ require true ]
     * @support  string $result 结果 [ require true ]
     * @support  array $note 备注 [ require true ]
     * @support  array $photoExamines 修改的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function examineSecond () {
        return self::getClass()->examineSecond();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CheckPool\HimoAppeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CheckPool\HimoAppeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}