<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method takePhotoByParams(array $params)
 * @method getHaveSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultListByParams(array $params)
 * @method getTodayEvaluateCountByParams(array $params)
 * @method getSearchHistoryByParams(array $params)
 * @method addScoreTypeByParams(array $params)
 * @method editScoreTypeByParams(array $params)
 * @method getScoreConfigListByParams(array $params)
 * @method addScoreConfigByParams(array $params)
 * @method editScoreConfigByParams(array $params)
 * @method delScoreConfigByParams(array $params)
 * @method emptyPoolByStaffIdByParams(array $params)
 * @method preCheckUpdateConfigByParams(array $params)
 * @method getScoreGeneralConfigByParams(array $params)
 * @method setNewConfigByParams(array $params)
 * @method commitHistoryByParams(array $params)
 * @method updateCommitHistoryByParams(array $params)
 * @method changeItemByParams(array $params)
 * @method skipStaffByParams(array $params)
 * @method lockUpdateConfigByParams(array $params)
 * @method unlockUpdateConfigByParams(array $params)
 */
class FamilyPhotographyPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Family摄影-抽片
     *
     * @support  array $productIds 产品id require false
     * @support  int $formalStaffCount 正式小伙伴单量 require false
     * @support  int $newStaffCount 新人小伙伴单量 require false
     * @throws  \Exception
     * @return  string
     */
    public static function takePhoto () {
        return self::getClass()->takePhoto();
    }

    /**
     * Family摄影-获取是否有未评分的抽片
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function getHaveSpotCheckResult () {
        return self::getClass()->getHaveSpotCheckResult();
    }

    /**
     * Family摄影-获取抽片结果
     *
     * @support  string $uuid 抽查配置UUID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResult () {
        return self::getClass()->getSpotCheckResult();
    }

    /**
     * Family摄影-获取抽片结果列表
     *
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @param  int $skip 跳过数量 [ require true ]
     * @param  int $limit 获取数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResultList (string $uuid, int $skip = 0, int $limit = 10) {
        return self::getClass()->getSpotCheckResultList([
            "uuid" => $uuid,
            "skip" => $skip,
            "limit" => $limit,
        ]);
    }

    /**
     * Family摄影-获取今日抽片指标
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayEvaluateCount () {
        return self::getClass()->getTodayEvaluateCount();
    }

    /**
     * Family摄影-获取历史记录
     *
     * @support  string $startAt 开始时间 require false
     * @support  string $endAt 结束时间 require false
     * @support  string $orderNum 订单号 require false
     * @support  array $productIds 产品ids require false
     * @support  array $staffIds 小伙伴ids require false
     * @support  array $positionIds 职能Id require false
     * @support  array $scoreConfigIds 评价标签 require false
     * @support  int $minScore 最小分值 require false
     * @support  int $mxScore 最大分值 require false
     * @support  int $type 类型，newStaff||formalStaff require false
     * @param  int $page 页数 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSearchHistory (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getSearchHistory([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * Family摄影-类别配置-添加
     *
     * @param  string $name 评分项名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreType (string $name) {
        return self::getClass()->addScoreType([
            "name" => $name,
        ]);
    }

    /**
     * Family摄影-类别配置-修改
     *
     * @support  int $id 类别id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreType (string $name) {
        return self::getClass()->editScoreType([
            "name" => $name,
        ]);
    }

    /**
     * Family摄影-评分配置-获取列表
     *
     * @param  bool $withTrashed 是否包含删除 [ require true ]
     * @support  bool $filterZero 是否去除包含0分的配置项 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getScoreConfigList (bool $withTrashed = false) {
        return self::getClass()->getScoreConfigList([
            "withTrashed" => $withTrashed,
        ]);
    }

    /**
     * Family摄影-评分配置-添加
     *
     * @param  int $scoreTypeId 类别id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return self::getClass()->addScoreConfig([
            "name" => $name,
            "children" => $children,
            "scoreTypeId" => $scoreTypeId,
        ]);
    }

    /**
     * Family摄影-评分配置-修改
     *
     * @support  int $id 评分项id [ require true ]
     * @support  string $name 评分项名称 require false
     * @support  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreConfig () {
        return self::getClass()->editScoreConfig();
    }

    /**
     * Family摄影-评分配置-删除
     *
     * @support  int $id 评分项id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delScoreConfig () {
        return self::getClass()->delScoreConfig();
    }

    /**
     * Family摄影-清空记录
     *
     * @support  array $staffIds 小伙伴ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function emptyPoolByStaffId () {
        return self::getClass()->emptyPoolByStaffId();
    }

    /**
     * 预检查是否可以更新配置
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function preCheckUpdateConfig () {
        return self::getClass()->preCheckUpdateConfig();
    }

    /**
     * Family摄影-评分配置-获取通用配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreGeneralConfig () {
        return self::getClass()->getScoreGeneralConfig();
    }

    /**
     * Family摄影-评分配置-新款应用设置
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function setNewConfig () {
        return self::getClass()->setNewConfig();
    }

    /**
     * Family摄影-提交评分
     *
     * @support  array $photos 打分明细 [ require true ]
     * @support  string $itemId 项目id [ require true ]
     * @support  array $tags 标签信息 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function commitHistory () {
        return self::getClass()->commitHistory();
    }

    /**
     * Family摄影-修改评分
     *
     * @support  array $photos 打分明细 [ require true ]
     * @support  string $itemId uuid [ require true ]
     * @support  array $tags 标签 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCommitHistory () {
        return self::getClass()->updateCommitHistory();
    }

    /**
     * Family摄影-换一单
     *
     * @support  string $itemId 项目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeItem () {
        return self::getClass()->changeItem();
    }

    /**
     * Family摄影-跳过伙伴
     *
     * @support  int $staffId 不处理的小伙伴id [ require true ]
     * @support  string $itemId 项目id [ require true ]
     * @support  bool $todayNotExtract 当天不抽取该伙伴 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function skipStaff () {
        return self::getClass()->skipStaff();
    }

    /**
     * 锁配置
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function lockUpdateConfig () {
        return self::getClass()->lockUpdateConfig();
    }

    /**
     * 解锁配置
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function unlockUpdateConfig () {
        return self::getClass()->unlockUpdateConfig();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CheckPool\FamilyPhotographyPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CheckPool\FamilyPhotographyPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}