<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAuditRecordTemplateByParams(array $params)
 * @method refreshPhotoAlgoByParams(array $params)
 */
class Template {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * test-创建提审记录
     *
     * @support  array $stream 流水 require false
     * @support  array $photos 图片 require false
     * @support  array $extends 扩展信息 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function createAuditRecordTemplate () {
        return self::getClass()->createAuditRecordTemplate();
    }

    /**
     * test-照片重新审核
     *
     * @support  array $photoIds 照片Ids require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshPhotoAlgo () {
        return self::getClass()->refreshPhotoAlgo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Template');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Template');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}