<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addStreamOrderByParams(array $params)
 */
class Stream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加流水订单信息
     *
     * @support  array $dressers 化妆师信息 require false
     * @support  int $streamId 流水id require false
     * @support  string $streamNum 流水号 require false
     * @support  string $orderNum 订单号 require false
     * @support  array $photographers 摄影师 require false
     * @support  array $product 产品信息 require false
     * @support  array $store 门店信息 require false
     * @support  int $storeId 门店id require false
     * @support  string $photographyNote 摄影备注 require false
     * @support  string $dresserNote 化妆备注 require false
     * @support  string $orderNote 订单备注 require false
     * @support  array $extends 订单拓展信息 require false
     * @support  array $photos 照片信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStreamOrder () {
        return self::getClass()->addStreamOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Api\Stream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Api\Stream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}