<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRoleListByParams(array $params)
 * @method getRoleInfoByParams(array $params)
 * @method addRoleByParams(array $params)
 * @method editRoleByParams(array $params)
 * @method delRoleByParams(array $params)
 * @method getPermissionListByParams(array $params)
 */
class Role {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取角色列表
     *
     * @support  int $page 分页 require false
     * @support  int $pageSize 每页大小 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getRoleList () {
        return self::getClass()->getRoleList();
    }

    /**
     * 获取角色详情
     *
     * @support  int $roleId 角色id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRoleInfo () {
        return self::getClass()->getRoleInfo();
    }

    /**
     * 添加角色
     *
     * @support  string $title 角色组名称 [ require true ]
     * @support  array $permissionIds 权限数组 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addRole () {
        return self::getClass()->addRole();
    }

    /**
     * 修改角色
     *
     * @support  int $roleId 角色id [ require true ]
     * @support  string $title 角色组名称 [ require true ]
     * @support  array $permissionIds 权限数组 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editRole () {
        return self::getClass()->editRole();
    }

    /**
     * 删除角色
     *
     * @param  int $roleId 角色id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delRole (int $roleId) {
        return self::getClass()->delRole([
            "roleId" => $roleId,
        ]);
    }

    /**
     * 获取所有权限列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissionList () {
        return self::getClass()->getPermissionList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Staff\Role');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Staff\Role');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}