<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAppealByParams(array $params)
 * @method getAppealByPageByParams(array $params)
 * @method getAppealQuotaByParams(array $params)
 * @method appealDetailByParams(array $params)
 * @method examineFirstByParams(array $params)
 * @method examineSecondByParams(array $params)
 * @method getAppealCountByParams(array $params)
 * @method bindFirstByParams(array $params)
 * @method bindSecondByParams(array $params)
 */
class FamilyAppeal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发起申诉
     *
     * @support  string $serviceType 业务类型 require false
     * @support  int $serviceId 业务唯一id,例如订单id [ require true ]
     * @support  array $appealContent 申诉内容 [ require true ]
     * @support  string $note 申诉备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAppeal () {
        return self::getClass()->createAppeal();
    }

    /**
     * 获取申诉分页
     *
     * @support  string $startAt 评分开始时间 require false
     * @support  string $endAt 评分开始时间 require false
     * @support  string $cloudOrderNum 订单号 require false
     * @support  string $serviceType 业务类型 require false
     * @support  array $appealStatus 申诉状态 require false
     * @support  int $inputStaffId 申请人id require false
     * @support  array $staffIds 伙伴id require false
     * @support  array $supervisorArr 督导ids require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealByPage () {
        return self::getClass()->getAppealByPage();
    }

    /**
     * 获取申诉绩效
     *
     * @support  string $startAt 评分开始时间 require false
     * @support  string $endAt 评分开始时间 require false
     * @support  string $serviceType 业务类型 require false
     * @support  string $appealStage 申诉阶段 require false
     * @support  array $inputStaffIds 申请人ids require false
     * @support  int $staffId 伙伴id require false
     * @support  array $supervisorArr 督导ids require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealQuota () {
        return self::getClass()->getAppealQuota();
    }

    /**
     * 获取申诉详情
     *
     * @param  int $id 申诉id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appealDetail (int $id) {
        return self::getClass()->appealDetail([
            "id" => $id,
        ]);
    }

    /**
     * 申诉审核
     *
     * @support  int $id 申诉id [ require true ]
     * @support  string $result 审核结果 [ require true ]
     * @support  string $note 问题标签申述备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function examineFirst () {
        return self::getClass()->examineFirst();
    }

    /**
     * 复审
     *
     * @support  int $id 申诉id [ require true ]
     * @support  string $result 结果 [ require true ]
     * @support  string $note 备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function examineSecond () {
        return self::getClass()->examineSecond();
    }

    /**
     * 审核总量
     *
     * @param  string $serviceType 业务类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAppealCount (string $serviceType) {
        return self::getClass()->getAppealCount([
            "serviceType" => $serviceType,
        ]);
    }

    /**
     * 初审绑定
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindFirst (int $id) {
        return self::getClass()->bindFirst([
            "id" => $id,
        ]);
    }

    /**
     * 复审绑定
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindSecond (int $id) {
        return self::getClass()->bindSecond([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CheckPool\FamilyAppeal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CheckPool\FamilyAppeal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}