<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method takePhotoByParams(array $params)
 * @method getHaveSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultListByParams(array $params)
 * @method getTodayEvaluateCountByParams(array $params)
 * @method getSearchHistoryByParams(array $params)
 * @method addScoreTypeByParams(array $params)
 * @method editScoreTypeByParams(array $params)
 * @method getScoreConfigListByParams(array $params)
 * @method addScoreConfigByParams(array $params)
 * @method editScoreConfigByParams(array $params)
 * @method delScoreConfigByParams(array $params)
 * @method emptyPoolByStaffIdByParams(array $params)
 * @method preCheckUpdateConfigByParams(array $params)
 * @method getScoreGeneralConfigByParams(array $params)
 * @method setNewConfigByParams(array $params)
 * @method commitHistoryByParams(array $params)
 * @method updateCommitHistoryByParams(array $params)
 * @method changeItemByParams(array $params)
 * @method skipStaffByParams(array $params)
 * @method lockUpdateConfigByParams(array $params)
 * @method unlockUpdateConfigByParams(array $params)
 * @method getAllQualityReportByParams(array $params)
 * @method getAreaQualityReportByParams(array $params)
 * @method getAreaQuotaByParams(array $params)
 * @method getAllQuotaByParams(array $params)
 * @method deleteHistoryByParams(array $params)
 */
class HimoPhotographyPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 海马体摄影-抽片
     *
     * @support  array $productIds 产品id require false
     * @support  int $formalStaffCount 正式小伙伴单量 [ require true ]
     * @support  int $newStaffCount 新人小伙伴单量 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function takePhoto () {
        return self::getClass()->takePhoto();
    }

    /**
     * 海马体摄影-获取是否有未评分的抽片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHaveSpotCheckResult () {
        return self::getClass()->getHaveSpotCheckResult();
    }

    /**
     * 海马体摄影-获取抽片结果
     *
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResult (string $uuid) {
        return self::getClass()->getSpotCheckResult([
            "uuid" => $uuid,
        ]);
    }

    /**
     * 海马体摄影-获取抽片结果列表
     *
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @param  int $skip 跳过数量 [ require true ]
     * @param  int $limit 获取数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResultList (string $uuid, int $skip = 0, int $limit = 10) {
        return self::getClass()->getSpotCheckResultList([
            "uuid" => $uuid,
            "skip" => $skip,
            "limit" => $limit,
        ]);
    }

    /**
     * 海马体摄影-获取今日抽片指标
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayEvaluateCount () {
        return self::getClass()->getTodayEvaluateCount();
    }

    /**
     * 海马体摄影-获取历史记录
     *
     * @support  string $startTime 评分开始时间 [ require true ]
     * @support  string $endTime 评分结束时间 [ require true ]
     * @support  array $productIds 产品ids require false
     * @support  array $problemTagsIds 问题标签ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $supervisorArr 督导ids, 职能小伙伴 require false
     * @support  array $score 评分分数 require false
     * @support  string $orderNum 拍摄订单号 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @param  int $page 页数 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSearchHistory (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getSearchHistory([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 海马体摄影-类别配置-添加
     *
     * @param  string $name 评分项名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreType (string $name) {
        return self::getClass()->addScoreType([
            "name" => $name,
        ]);
    }

    /**
     * 海马体摄影-类别配置-修改
     *
     * @param  int $id 类别id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreType (int $id, string $name) {
        return self::getClass()->editScoreType([
            "id" => $id,
            "name" => $name,
        ]);
    }

    /**
     * 海马体摄影-评分配置-获取列表
     *
     * @param  bool $withTrashed 是否包含删除 [ require true ]
     * @support  bool $filterZero 是否去除包含0分的配置项 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreConfigList (bool $withTrashed = false) {
        return self::getClass()->getScoreConfigList([
            "withTrashed" => $withTrashed,
        ]);
    }

    /**
     * 海马体摄影-评分配置-添加
     *
     * @param  int $scoreTypeId 类别id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return self::getClass()->addScoreConfig([
            "name" => $name,
            "children" => $children,
            "scoreTypeId" => $scoreTypeId,
        ]);
    }

    /**
     * 海马体摄影-评分配置-修改
     *
     * @param  int $id 评分项id [ require true ]
     * @param  string $name 评分项名称 [ require true ]
     * @param  array $children 配置data [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editScoreConfig (int $id, string $name, array $children) {
        return self::getClass()->editScoreConfig([
            "id" => $id,
            "name" => $name,
            "children" => $children,
        ]);
    }

    /**
     * 海马体摄影-评分配置-删除
     *
     * @param  int $id 评分项id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delScoreConfig (int $id) {
        return self::getClass()->delScoreConfig([
            "id" => $id,
        ]);
    }

    /**
     * 海马体摄影-清空记录
     *
     * @param  array $staffIds 小伙伴ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function emptyPoolByStaffId (array $staffIds = []) {
        return self::getClass()->emptyPoolByStaffId([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 预检查是否可以更新配置
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function preCheckUpdateConfig () {
        return self::getClass()->preCheckUpdateConfig();
    }

    /**
     * 海马体摄影-评分配置-获取通用配置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreGeneralConfig () {
        return self::getClass()->getScoreGeneralConfig();
    }

    /**
     * 海马体摄影-评分配置-新款应用设置
     *
     * @param  bool $state 开关状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setNewConfig (bool $state) {
        return self::getClass()->setNewConfig([
            "state" => $state,
        ]);
    }

    /**
     * 海马体摄影-提交评分
     *
     * @support  array $photos 打分明细 [ require true ]
     * @support  string $poolItemId 项目id [ require true ]
     * @support  array $tags 标签信息 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function commitHistory () {
        return self::getClass()->commitHistory();
    }

    /**
     * 海马体摄影-修改评分
     *
     * @support  array $photos 打分明细 [ require true ]
     * @support  string $poolItemId 项目id [ require true ]
     * @support  array $tags 标签 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCommitHistory () {
        return self::getClass()->updateCommitHistory();
    }

    /**
     * 海马体摄影-换一单
     *
     * @param  string $poolItemId poolItemId [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeItem (string $poolItemId, string $uuid) {
        return self::getClass()->changeItem([
            "poolItemId" => $poolItemId,
            "uuid" => $uuid,
        ]);
    }

    /**
     * 海马体摄影-跳过伙伴
     *
     * @support  array $staffIds 不处理的小伙伴id [ require true ]
     * @support  string $poolItemId 项目id [ require true ]
     * @support  bool $todayNotExtract 当天不抽取该伙伴 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function skipStaff () {
        return self::getClass()->skipStaff();
    }

    /**
     * 锁配置
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function lockUpdateConfig () {
        return self::getClass()->lockUpdateConfig();
    }

    /**
     * 解锁配置
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function unlockUpdateConfig () {
        return self::getClass()->unlockUpdateConfig();
    }

    /**
     * 获取质检报告(全员)
     *
     * @support  string $startTime 评分开始时间 [ require true ]
     * @support  string $endTime 评分结束时间 [ require true ]
     * @support  array $productIds 产品ids require false
     * @support  array $problemTagsIds 问题标签ids require false
     * @support  array $supervisorArr 督导ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $score 评分分数 require false
     * @support  string $orderNum 拍摄订单号 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllQualityReport () {
        return self::getClass()->getAllQualityReport();
    }

    /**
     * 获取质检报告(区域)
     *
     * @support  string $startTime 评分开始时间 [ require true ]
     * @support  string $endTime 评分结束时间 [ require true ]
     * @support  array $productIds 产品ids require false
     * @support  array $problemTagsIds 问题标签ids require false
     * @support  array $supervisorArr 督导ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $score 评分分数 require false
     * @support  string $orderNum 拍摄订单号 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAreaQualityReport () {
        return self::getClass()->getAreaQualityReport();
    }

    /**
     * 获取质检报告(区域)绩效
     *
     * @support  string $startTime 评分开始时间 [ require true ]
     * @support  string $endTime 评分结束时间 [ require true ]
     * @support  array $productIds 产品ids require false
     * @support  array $problemTagsIds 问题标签ids require false
     * @support  array $supervisorArr 督导ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $score 评分分数 require false
     * @support  string $orderNum 拍摄订单号 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAreaQuota () {
        return self::getClass()->getAreaQuota();
    }

    /**
     * 获取质检报告(全员)绩效
     *
     * @support  string $startTime 评分开始时间 [ require true ]
     * @support  string $endTime 评分结束时间 [ require true ]
     * @support  array $productIds 产品ids require false
     * @support  array $problemTagsIds 问题标签ids require false
     * @support  array $supervisorArr 督导ids require false
     * @support  array $staffIds 伙伴ids require false
     * @support  array $score 评分分数 require false
     * @support  string $orderNum 拍摄订单号 require false
     * @support  bool $onlyNew 只看新人 require false
     * @support  bool $onlyOld 只看正式伙伴 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页数量 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllQuota () {
        return self::getClass()->getAllQuota();
    }

    /**
     * 删除项目
     *
     * @param  string $poolItemId 项目id [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteHistory (string $poolItemId, string $uuid) {
        return self::getClass()->deleteHistory([
            "poolItemId" => $poolItemId,
            "uuid" => $uuid,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'CheckPool\HimoPhotographyPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'CheckPool\HimoPhotographyPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}