<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSelfInfoByParams(array $params)
 * @method getAuthorityByParams(array $params)
 * @method getScoreConfigTreeByParams(array $params)
 * @method getProductCategoryTreeByParams(array $params)
 * @method getPositionsByParams(array $params)
 * @method getStoreStaffTreeByParams(array $params)
 * @method searchPositionStaffsByParams(array $params)
 * @method getPositionStaffsByParams(array $params)
 * @method getAllRoleByParams(array $params)
 * @method getAllStoreByParams(array $params)
 * @method getTakeStaffListByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前个人信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfInfo () {
        return self::getClass()->getSelfInfo();
    }

    /**
     * 获取权限信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAuthority () {
        return self::getClass()->getAuthority();
    }

    /**
     * 获取评分配置列表
     *
     * @param  string $poolName 类型:himo_makeup_pool|himo_photography_pool|family_makeup_pool|family_photography_pool [ require true ]
     * @param  bool $withTrashed 是否包含删除 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreConfigTree (string $poolName, bool $withTrashed = false) {
        return self::getClass()->getScoreConfigTree([
            "poolName" => $poolName,
            "withTrashed" => $withTrashed,
        ]);
    }

    /**
     * 根据根节点id获取产品分类树
     *
     * @param  int $rootId 根分类节点id，获取整树所有则传0 [ require true ]
     * @param  bool $withProduct 是否需要产品列表,默认为false [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCategoryTree (int $rootId, bool $withProduct = false) {
        return self::getClass()->getProductCategoryTree([
            "rootId" => $rootId,
            "withProduct" => $withProduct,
        ]);
    }

    /**
     * 获取职位列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPositions () {
        return self::getClass()->getPositions();
    }

    /**
     * 获取门店小伙伴级联树
     *
     * @param  array $state 门店类型 [ require true ]
     * @param  string $type 类型:makeup|photography [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreStaffTree (array $state, string $type = 'makeup') {
        return self::getClass()->getStoreStaffTree([
            "state" => $state,
            "type" => $type,
        ]);
    }

    /**
     * 查询职能组小伙伴
     *
     * @param  int $staffId 小伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchPositionStaffs (int $staffId) {
        return self::getClass()->searchPositionStaffs([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取职能组小伙伴树
     *
     * @param  string $type 类型:makeup|photography [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPositionStaffs (string $type = '') {
        return self::getClass()->getPositionStaffs([
            "type" => $type,
        ]);
    }

    /**
     * 获取全部角色组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllRole () {
        return self::getClass()->getAllRole();
    }

    /**
     * 获取全部门店
     *
     * @param  array $state 门店类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStore (array $state = []) {
        return self::getClass()->getAllStore([
            "state" => $state,
        ]);
    }

    /**
     * 获取全部评分人
     *
     * @param  string $type 评分人类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTakeStaffList (string $type) {
        return self::getClass()->getTakeStaffList([
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}