<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality\Staff;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByParams(array $params)
 * @method getStaffInfoByParams(array $params)
 * @method addStaffByParams(array $params)
 * @method editStaffByParams(array $params)
 * @method enableStaffByParams(array $params)
 * @method disableStaffByParams(array $params)
 */
class StaffAccount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取账号列表
     *
     * @support  int $staffId staffId require false
     * @support  string $staffName 伙伴姓名/花名 require false
     * @support  int $roleId 角色id require false
     * @param  int $page 分页 [ require true ]
     * @param  int $pageSize 每页大小 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStaffList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取账号信息
     *
     * @support  int $staffId 伙伴工号 require false
     * @support  string $staffName 伙伴姓名/花名 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfo () {
        return self::getClass()->getStaffInfo();
    }

    /**
     * 添加账号
     *
     * @support  array $configStoreIds 管辖门店数组 require false
     * @support  array $configStaffIds 管辖小伙伴数组 require false
     * @support  int $roleId 角色组 require false
     * @support  array $permissionIds 权限ids require false
     * @support  int $positionId 职能id [ require true ]
     * @support  int $staffId 小伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addStaff () {
        return self::getClass()->addStaff();
    }

    /**
     * 修改账号
     *
     * @support  array $configStoreIds 管辖门店数组 require false
     * @support  array $configStaffIds 管辖小伙伴数组 require false
     * @support  int $roleId 角色组 require false
     * @support  array $permissionIds 权限ids require false
     * @support  int $positionId 职能id [ require true ]
     * @support  int $staffId 小伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function editStaff () {
        return self::getClass()->editStaff();
    }

    /**
     * 启用小伙伴
     *
     * @param  int $staffId 小伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function enableStaff (int $staffId) {
        return self::getClass()->enableStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 禁用小伙伴
     *
     * @param  int $staffId 小伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function disableStaff (int $staffId) {
        return self::getClass()->disableStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Staff\StaffAccount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Staff\StaffAccount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}