<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSelfInfoByParams(array $params)
 * @method getAuthorityByParams(array $params)
 * @method getScoreConfigTreeByParams(array $params)
 * @method getProductCategoryTreeByParams(array $params)
 * @method getPositionsByParams(array $params)
 * @method getStaffsByParams(array $params)
 * @method getPositionStaffsByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前个人信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfInfo () {
        return self::getClass()->getSelfInfo();
    }

    /**
     * 获取权限信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAuthority () {
        return self::getClass()->getAuthority();
    }

    /**
     * 获取评分配置列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreConfigTree () {
        return self::getClass()->getScoreConfigTree();
    }

    /**
     * 根据根节点id获取产品分类树
     *
     * @support  int $rootId 根分类节点id，获取整树所有则传0 [ require true ]
     * @support  bool $withProduct 是否需要产品列表,默认为false require false
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCategoryTree () {
        return self::getClass()->getProductCategoryTree();
    }

    /**
     * 获取职位列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPositions () {
        return self::getClass()->getPositions();
    }

    /**
     * 获取小伙伴
     *
     * @support  bool $needDelete 需要禁用的账户 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffs () {
        return self::getClass()->getStaffs();
    }

    /**
     * 获取职能组
     *
     * @support  string $type 类型:makeup|photography require false
     * @throws  \Exception
     * @return  array
     */
    public static function getPositionStaffs () {
        return self::getClass()->getPositionStaffs();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}