<?php
namespace Mainto\Bridge\Enums\ProjectPhotoQuality\PhotoQuality;

class PhotoQualityEnum {
    /**
     * 提审记录id
     */
    const AUDIT_RECORD_ID = 'audit_record_id';
    /**
     * 图片地址
     */
    const PATH = 'path';
    /**
     * 摄影异常程度, [0-5, 5是正常的]
     */
    const PHOTOGRAPHY_DEGREE = 'photography_degree';
    /**
     * 化妆异常程度, [0-5, 5是正常的]
     */
    const MAKEUP_DEGREE = 'makeup_degree';
    /**
     * 审核完成时间, 用于展示判断
     */
    const FINISH_TIME = 'finish_time';
    /**
     * 审核记录总单量[以cloud_order_num维度]
     */
    const AUDIT_RECORD_COUNT = 'audit_record_count';
    /**
     * 审核记录总张数[照片维度]
     */
    const PHOTO_QUALITY_COUNT = 'photo_quality_count';
    /**
     * 问题单量[以cloud_order_num维度]
     */
    const AUDIT_RECORD_PROBLEM_COUNT = 'audit_record_problem_count';
    /**
     * 问题张数[照片维度]
     */
    const PHOTO_QUALITY_PROBLEM_COUNT = 'photo_quality_problem_count';
    /**
     * AI审核异常程度
     */
    const DEGREE = ['normal' => [0 => 5],'abnormal' => [0 => 0,1 => 1,2 => 2,3 => 3,4 => 4]];
}