<?php
namespace Mainto\Bridge\Invokes\ProjectPhotoQuality;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuditRecordTotalByParams(array $params)
 * @method getAuditRecordsByParams(array $params)
 */
class PhotographyPhotoQuality {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 摄影提审记录统计
     *
     * @support  string $startAt 评分开始时间 require false
     * @support  string $endAt 评分开始时间 require false
     * @support  string $cloudOrderNum 订单号 require false
     * @support  string $auditState AI标签:normal|abnormal require false
     * @support  int $pageSize  require false
     * @support  int $page  require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAuditRecordTotal () {
        return self::getClass()->getAuditRecordTotal();
    }

    /**
     * 摄影提审记录列表
     *
     * @support  string $startAt 评分开始时间 require false
     * @support  string $endAt 评分开始时间 require false
     * @support  string $cloudOrderNum 订单号 require false
     * @support  string $auditState AI标签:normal|abnormal require false
     * @param  int $pageSize  [ require true ]
     * @param  int $page  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAuditRecords (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAuditRecords([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPhotoQuality', 'PhotographyPhotoQuality');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPhotoQuality', 'PhotographyPhotoQuality');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}