<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method searchStreamByParams(array $params)
 * @method cloudListByParams(array $params)
 */
class Stream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 该接口被Rpc调用
     *
     * @support  string $streamNum 流水号 [ require false ]
     * @support  string $orderId 订单id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 该接口被Rpc调用
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  int $photographerId 摄影师id [ require false ]
     * @support  array $photographerIds 摄影师ids [ require false ]
     * @support  int $secondRetoucherId 看片师id [ require false ]
     * @support  array $secondRetoucherIds 看片师ids [ require false ]
     * @support  array $productIds 产品ids [ require false ]
     * @support  array $orderNos 订单号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchStream () {
        return self::getClass()->searchStream([
        ]);
    }

    /**
     * 获取云端订单下所有正常流水
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\CloudStreamResDto[]
     */
    public static function cloudList (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->cloudList([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\CloudStreamResDto[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Stream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Stream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}