<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method paperlessOrdersByParams(array $params)
 * @method saveNoteByParams(array $params)
 * @method getOrderStageNumsByParams(array $params)
 * @method getMakeUpAssignStaffsByParams(array $params)
 * @method getAssignWorkloadsByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\OrderAssignWorkloadCmd $params)
 * @method assignStageStaffByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\AssignStageStaffCmd $params)
 * @method cancelAssignStageStaffByParams(array $params)
 * @method hangByParams(array $params)
 * @method cancelHangByParams(array $params)
 * @method changeStaffByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\ChangeStaffCmd $params)
 * @method makeUpChangeStaffByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\MakeUpChangeStaffCmd $params)
 * @method cancelAssistByParams(array $params)
 * @method updateSortByParams(array $params)
 * @method getCanTakeOrderStaffIdsByParams(array $params)
 * @method backWaitPhotographyByParams(array $params)
 * @method backWaitMakeUpByParams(array $params)
 * @method backWaitLookPhotoByParams(array $params)
 * @method hasOffProductsByParams(array $params)
 * @method getStageStaffsByParams(array $params)
 * @method bigOrderByParams(array $params)
 * @method getOrderPreAssignStaffsByParams(array $params)
 * @method getOrderCurrentAssignStaffsByParams(array $params)
 * @method checkNeedPaperlessByParams(array $params)
 * @method maintoPhotographyExtendInfoByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Order\MaintoPhotograpy\Dto\ExtendInfoDto $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $page 页码 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  bool $sortDesc 是否倒序 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  string $searchField 搜索字段 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Order\OrderListPageDTO
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Order\OrderListPageDTO"
        );
    }

    /**
     * 无纸化订单列表
     *
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $stage 流程状态 [ require false ]
     * @support  int $storeId 门店id [ require true ]
     * @support  bool $isPrinted 是否打印 [ require false ]
     * @support  bool $isPosted 是否邮寄 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  string $searchField 搜索字段 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\PaperlessOrderPageDTO
     */
    public static function paperlessOrders () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->paperlessOrders([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\PaperlessOrderPageDTO"
        );
    }

    /**
     * 更新订单备注信息
     *
     * @support  int $orderId 订单id [ require false ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveNote () {
        return self::getClass()->saveNote([
        ]);
    }

    /**
     * 拍摄状态数量统计
     *
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\ProcessStageNumsDTO
     */
    public static function getOrderStageNums () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderStageNums([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\ProcessStageNumsDTO"
        );
    }

    /**
     * 获取订单的协作分配信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\ProcessAssistantPeopleDTO[]
     */
    public static function getMakeUpAssignStaffs () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMakeUpAssignStaffs(),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\ProcessAssistantPeopleDTO[]"
        );
    }

    /**
     * 获取订单的协作工作量信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\OrderAssignWorkloadCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\OrderAssistantWorkloadDTO
     */
    public static function getAssignWorkloads (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\OrderAssignWorkloadCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAssignWorkloads($cmd),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\OrderAssistantWorkloadDTO"
        );
    }


    /**
     * 指定订单接单伙伴
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\AssignStageStaffCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function assignStageStaff (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\AssignStageStaffCmd $cmd) {
        return self::getClass()->assignStageStaff($cmd);
    }


    /**
     * 清除订单接单伙伴
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $stage 阶段 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAssignStageStaff () {
        return self::getClass()->cancelAssignStageStaff([
        ]);
    }

    /**
     * 挂起订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hang () {
        return self::getClass()->hang([
        ]);
    }

    /**
     * 取消挂起订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelHang () {
        return self::getClass()->cancelHang([
        ]);
    }

    /**
     * 更换伙伴
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\ChangeStaffCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeStaff (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\ChangeStaffCmd $cmd) {
        return self::getClass()->changeStaff($cmd);
    }


    /**
     * 化妆阶段更换伙伴
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\MakeUpChangeStaffCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function makeUpChangeStaff (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\MakeUpChangeStaffCmd $cmd) {
        return self::getClass()->makeUpChangeStaff($cmd);
    }


    /**
     * 取消协作
     *
     * @param  int $processId 流程id [ require true ]
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAssist (int $processId, int $staffId) {
        return self::getClass()->cancelAssist([
            "processId" => $processId,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 更新接单顺序
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $sort 排序值 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateSort () {
        return self::getClass()->updateSort([
        ]);
    }

    /**
     * 获取订单可接单伙伴ids
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\CanTakeOrderStaffDTO
     */
    public static function getCanTakeOrderStaffIds () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCanTakeOrderStaffIds([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\CanTakeOrderStaffDTO"
        );
    }

    /**
     * 退回至等待摄影
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitPhotography () {
        return self::getClass()->backWaitPhotography([
        ]);
    }

    /**
     * 退回至等待化妆
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitMakeUp () {
        return self::getClass()->backWaitMakeUp([
        ]);
    }

    /**
     * 退回至看片排队中
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitLookPhoto () {
        return self::getClass()->backWaitLookPhoto([
        ]);
    }

    /**
     * 订单中是否存在已下架产品
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hasOffProducts () {
        return self::getClass()->hasOffProducts([
        ]);
    }

    /**
     * 获取订单的伙伴列表
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\StageStaffsDTO[]
     */
    public static function getStageStaffs () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStageStaffs([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\StageStaffsDTO[]"
        );
    }

    /**
     * 是否是大订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bigOrder (int $orderId) {
        return self::getClass()->bigOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取订单预指派的伙伴信息
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\OrderPreAssignStaffsDTO
     */
    public static function getOrderPreAssignStaffs () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderPreAssignStaffs([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\OrderPreAssignStaffsDTO"
        );
    }

    /**
     * 获取订单当前指派的伙伴信息
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\OrderPreAssignStaffsDTO
     */
    public static function getOrderCurrentAssignStaffs (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderCurrentAssignStaffs([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\OrderPreAssignStaffsDTO"
        );
    }

    /**
     * 检查是否需要走钉钉无纸化（兼容family合并后部分老kids门店不走钉钉无纸化）
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkNeedPaperless (int $storeId) {
        return self::getClass()->checkNeedPaperless([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 更新缦图摄影订单额外信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Order\MaintoPhotograpy\Dto\ExtendInfoDto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function maintoPhotographyExtendInfo (\Mainto\Bridge\Structs\ProjectPaperless\Order\MaintoPhotograpy\Dto\ExtendInfoDto $dto) {
        return self::getClass()->maintoPhotographyExtendInfo($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}