<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWorkStatesByParams(array $params)
 * @method getAvailableStaffIdsByParams(array $params)
 * @method getCurrentHangStaffsByParams(array $params)
 * @method getHangTimeoutStaffsByParams(array $params)
 * @method storeStaffsByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴工作状态
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Store\GetWorkStatesDTO[]
     */
    public static function getWorkStates () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getWorkStates(),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Store\GetWorkStatesDTO[]"
        );
    }

    /**
     * 获取伙伴工作状态
     *
     * @support  int $orderId 订单号 [ require false ]
     * @support  array $staffIds 伙伴id列表 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Store\GetAvailableStaffIdsDTO[]
     */
    public static function getAvailableStaffIds () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAvailableStaffIds([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Store\GetAvailableStaffIdsDTO[]"
        );
    }

    /**
     * 获取当前挂起的用户列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentHangStaffs () {
        return self::getClass()->getCurrentHangStaffs();
    }

    /**
     * 获取挂起超时的用户列表
     *
     * @support  int $time 挂起时间 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHangTimeoutStaffs () {
        return self::getClass()->getHangTimeoutStaffs([
        ]);
    }

    /**
     * 根据伙伴类型获取成员列表
     *
     * @support  string $staffType 伙伴类型 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Store\StoreStaffsDTO[]
     */
    public static function storeStaffs () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->storeStaffs([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Store\StoreStaffsDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}