<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cloudProductInfoByParams(array|Product\CloudProductInfo\ProductInfoDto $params)
 * @method productRetouchStyleByParams(array $params)
 * @method evaluateRetoucherByParams(array|Product\EvaluateRetoucher\EvaluateRetoucherDto $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品信息
     *
     * @var  Product\CloudProductInfo\ProductInfoDto $dto $dto
     * @throws  \Exception
     * @return  array
     */
    public static function cloudProductInfo (Product\CloudProductInfo\ProductInfoDto $dto) {
        return self::getClass()->cloudProductInfo($dto);
    }


    /**
     * 获取云端产品的修图风格
     *
     * @throws  \Exception
     * @return  array
     */
    public static function productRetouchStyle () {
        return self::getClass()->productRetouchStyle();
    }

    /**
     * 评价修图师风格
     *
     * @var  Product\EvaluateRetoucher\EvaluateRetoucherDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function evaluateRetoucher (Product\EvaluateRetoucher\EvaluateRetoucherDto $dto) {
        return self::getClass()->evaluateRetoucher($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}