<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userSignInByParams(array $params)
 * @method retouchSignInByParams(array $params)
 * @method reviewStoreListByParams(array $params)
 * @method cloudBackColorByParams(array|Process\CloudBackColor\OrderDto $params)
 * @method updateCloudBackColorByParams(array|Process\UpdateCloudBackColor\UpdateBackColorDto $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 前台签到
     *
     * @support  int $staffId 员工id require false
     * @support  int $orderId 订单id [ require true ]
     * @support  int $dresserId 指定的化妆师id require false
     * @support  int $cameramanId 指定的摄影师id require false
     * @support  bool $skipMakeUp 是否跳过化妆 require false
     * @support  int $groupId 分组id require false
     * @support  array $saleSex 到店签到人性别 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userSignIn () {
        return self::getClass()->userSignIn();
    }

    /**
     * 看片签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $retoucherId 指定的看片师id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function retouchSignIn () {
        return self::getClass()->retouchSignIn();
    }

    /**
     * 支持预约看片门店列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewStoreList () {
        return self::getClass()->reviewStoreList();
    }

    /**
     * 获取订单下产品的修图底色
     *
     * @var  Process\CloudBackColor\OrderDto $dto $dto
     * @throws  \Exception
     * @return  array
     */
    public static function cloudBackColor (Process\CloudBackColor\OrderDto $dto) {
        return self::getClass()->cloudBackColor($dto);
    }


    /**
     * 更新订单下产品的修图底色
     *
     * @var  Process\UpdateCloudBackColor\UpdateBackColorDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCloudBackColor (Process\UpdateCloudBackColor\UpdateBackColorDto $dto) {
        return self::getClass()->updateCloudBackColor($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}