<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method searchStreamByParams(array $params)
 * @method hookStreamProblemTagPhotographyByParams(array $params)
 * @method hookStreamProblemTagMakeupByParams(array $params)
 * @method hookStreamPhotoMetaTagByParams(array $params)
 * @method cloudListByParams(array $params)
 */
class Stream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询单条流水
     *
     * @support  string $streamNum 流水号 require false
     * @support  string $orderId 订单id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 查询流水数据
     *
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  int $photographerId 摄影师id require false
     * @support  array $photographerIds 摄影师ids require false
     * @support  int $secondRetoucherId 看片师id require false
     * @support  array $secondRetoucherIds 看片师ids require false
     * @support  array $productIds 产品ids require false
     * @support  array $orderNos 订单号 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchStream () {
        return self::getClass()->searchStream();
    }

    /**
     * hook流水－摄影问题标签
     *
     * @param  string $streamNum 流水num [ require true ]
     * @param  int $photoCount 照片数 [ require true ]
     * @param  array $tags 问题标签 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamProblemTagPhotography (string $streamNum, int $photoCount, array $tags) {
        return self::getClass()->hookStreamProblemTagPhotography([
            "streamNum" => $streamNum,
            "photoCount" => $photoCount,
            "tags" => $tags,
        ]);
    }

    /**
     * hook流水－化妆问题标签
     *
     * @support  int $streamId 流水id [ require true ]
     * @param  string $streamNum 流水num [ require true ]
     * @param  int $photoCount 照片数 [ require true ]
     * @param  array $tags 问题标签 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamProblemTagMakeup (string $streamNum, int $photoCount, array $tags) {
        return self::getClass()->hookStreamProblemTagMakeup([
            "streamNum" => $streamNum,
            "photoCount" => $photoCount,
            "tags" => $tags,
        ]);
    }

    /**
     * hook流水－图片七牛云标签
     *
     * @param  string $streamNum 流水num [ require true ]
     * @param  array $photos 照片组 [ require true ]
     * @param  array $photoMeta photoMeta [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamPhotoMetaTag (string $streamNum, array $photos, array $photoMeta = []) {
        return self::getClass()->hookStreamPhotoMetaTag([
            "streamNum" => $streamNum,
            "photos" => $photos,
            "photoMeta" => $photoMeta,
        ]);
    }

    /**
     * 获取云端订单下所有正常流水
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cloudList (int $orderId) {
        return self::getClass()->cloudList([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Stream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Stream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}