<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInfoByParams(array $params)
 * @method getDingDingHeadByParams(array $params)
 * @method chooseTypeByParams(array $params)
 * @method beginWorkByParams(array $params)
 * @method endWorkByParams(array $params)
 * @method hangByParams(array $params)
 * @method cancelHangByParams(array $params)
 * @method getTodayWorkDetailsByParams(array $params)
 * @method getStaffOrdersByParams(array $params)
 * @method getStaffStatusByParams(array $params)
 * @method getAssistantsByParams(array $params)
 * @method getNamesByStaffIdsByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo ($context) {
        return self::getClass()->getInfo();
    }

    /**
     * 获取钉钉头像
     *
     * @support  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDingDingHead ($context) {
        return self::getClass()->getDingDingHead([
            "context" => $context,
        ]);
    }

    /**
     * 选择进入的身份类型[done]
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  int $staffId 伙伴id [ require false ]
     * @support  string $staffType 摄影师: sys,化妆师: hzs [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseType ($context) {
        return self::getClass()->chooseType([
            "context" => $context,
        ]);
    }

    /**
     * 开始工作
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function beginWork ($context) {
        return self::getClass()->beginWork();
    }

    /**
     * 结束工作
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function endWork ($context) {
        return self::getClass()->endWork();
    }

    /**
     * 挂起
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function hang ($context) {
        return self::getClass()->hang();
    }

    /**
     * 取消挂起
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelHang ($context) {
        return self::getClass()->cancelHang();
    }

    /**
     * 获取今日工作明细
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTodayWorkDetails ($context) {
        return self::getClass()->getTodayWorkDetails();
    }

    /**
     * 获取伙伴订单列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffOrders ($context) {
        return self::getClass()->getStaffOrders();
    }

    /**
     * 获取伙伴的状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffStatus ($context) {
        return self::getClass()->getStaffStatus();
    }

    /**
     * 获取可协作的伙伴列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAssistants ($context) {
        return self::getClass()->getAssistants();
    }

    /**
     * 通过staffIds获取伙伴名字列表
     *
     * @support  array $staffIds 伙伴id列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNamesByStaffIds ($context) {
        return self::getClass()->getNamesByStaffIds([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'User\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'User\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}