<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getQueueInfoByParams(array $params)
 * @method debugByParams(array $params)
 * @method whyByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method pingWebsocketByParams(array $params)
 * @method refreshOrderStageByParams(array $params)
 * @method closeProcessByParams(array $params)
 * @method addProcessesByParams(array $params)
 * @method takeOrderDetailByParams(array $params)
 * @method refreshStaffStateByParams(array $params)
 * @method saveProcessByParams(array $params)
 * @method testFuncByParams(array $params)
 * @method testMessageSendByParams(array $params)
 * @method sendXiuNotifyByParams(array $params)
 * @method fixHangOrderByParams(array $params)
 * @method newStagesByParams(array $params)
 * @method removeOrderStageNumsCacheByParams(array $params)
 * @method tabOrderProcessNotDealWithByParams(array $params)
 * @method failByParams(array $params)
 * @method fail2ByParams(array $params)
 * @method retakeProcessByParams(array $params)
 * @method fixProcessByParams(array $params)
 */
class Debug {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getQueueInfo
     *
     * @param  string $storeId storeId [ require true ]
     * @param  bool $refresh refresh [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueInfo (string $storeId, bool $refresh = false) {
        return self::getClass()->getQueueInfo([
            "storeId" => $storeId,
            "refresh" => $refresh,
        ]);
    }

    /**
     * debug
     *
     * @support  string $orderNo orderNo [ require false ]
     * @support  string $orderId orderId [ require false ]
     * @support  string $staffId orderId [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function debug ($context) {
        return self::getClass()->debug([
            "context" => $context,
        ]);
    }

    /**
     * why
     *
     * @param  int $storeId storeId [ require true ]
     * @param  int $staffId staffId [ require true ]
     * @param  string $staffType staffType [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function why (int $storeId, int $staffId, string $staffType) {
        return self::getClass()->why([
            "storeId" => $storeId,
            "staffId" => $staffId,
            "staffType" => $staffType,
        ]);
    }

    /**
     * getProductsInOrder
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInOrder (int $id) {
        return self::getClass()->getProductsInOrder([
            "id" => $id,
        ]);
    }

    /**
     * ping websocket
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  int $staffId 伙伴id [ require false ]
     * @support  string $staffType 摄影师: sys,化妆师: hzs [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pingWebsocket ($context) {
        return self::getClass()->pingWebsocket([
            "context" => $context,
        ]);
    }

    /**
     * 重新计算订单状态
     *
     * @support  int $orderId 订单id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshOrderStage ($context) {
        return self::getClass()->refreshOrderStage([
            "context" => $context,
        ]);
    }

    /**
     * closeProcess
     *
     * @param  int $processId processId [ require true ]
     * @param  string $reason reason [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeProcess (int $processId, string $reason) {
        return self::getClass()->closeProcess([
            "processId" => $processId,
            "reason" => $reason,
        ]);
    }

    /**
     * addProcesses
     *
     * @param  int $orderId orderId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProcesses (int $orderId) {
        return self::getClass()->addProcesses([
            "orderId" => $orderId,
        ]);
    }

    /**
     * takeOrderDetail
     *
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeOrderDetail (string $key) {
        return self::getClass()->takeOrderDetail([
            "key" => $key,
        ]);
    }

    /**
     * 伙伴状态恢复到等待
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  int $staffId 伙伴id [ require false ]
     * @support  string $staffType 伙伴类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshStaffState ($context) {
        return self::getClass()->refreshStaffState([
            "context" => $context,
        ]);
    }

    /**
     * saveProcess
     *
     * @support  string $token token [ require true ]
     * @support  int $staffId staffId [ require true ]
     * @support  string $staffType staffType [ require true ]
     * @support  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveProcess ($context) {
        return self::getClass()->saveProcess([
            "context" => $context,
        ]);
    }

    /**
     * testFunc
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function testFunc ($context) {
        return self::getClass()->testFunc();
    }

    /**
     * testMessageSend
     *
     * @support  string $key MessageKey [ require true ]
     * @support  string $params params [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function testMessageSend ($context) {
        return self::getClass()->testMessageSend([
            "context" => $context,
        ]);
    }

    /**
     * 摄影师底片推送
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendXiuNotify ($context) {
        return self::getClass()->sendXiuNotify();
    }

    /**
     * fixHangOrder
     *
     * @support  string $orderIds 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixHangOrder ($context) {
        return self::getClass()->fixHangOrder([
            "context" => $context,
        ]);
    }

    /**
     * newStages
     *
     * @support  string $processIds processIds [ require true ]
     * @support  string $stage stage [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newStages ($context) {
        return self::getClass()->newStages([
            "context" => $context,
        ]);
    }

    /**
     * 清除门店无纸化订单数的缓存
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function removeOrderStageNumsCache (array $storeIds) {
        return self::getClass()->removeOrderStageNumsCache([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 标记订单process没有上传流水为无需上传
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function tabOrderProcessNotDealWith (int $orderId) {
        return self::getClass()->tabOrderProcessNotDealWith([
            "orderId" => $orderId,
        ]);
    }

    /**
     * fail
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function fail ($context) {
        return self::getClass()->fail();
    }

    /**
     * fail2
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function fail2 ($context) {
        return self::getClass()->fail2();
    }

    /**
     * retakeProcess
     *
     * @support  array $processIds processIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retakeProcess ($context) {
        return self::getClass()->retakeProcess([
            "context" => $context,
        ]);
    }

    /**
     * 恢复被删除的 process
     *
     * @support  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixProcess ($context) {
        return self::getClass()->fixProcess([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Debug');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Debug');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}