<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userSignInByParams(array $params)
 * @method retouchSignInByParams(array $params)
 * @method reviewStoreListByParams(array $params)
 * @method getProcessInfoByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 前台签到
     *
     * @support  int $staffId 员工id require false
     * @support  int $orderId 订单id [ require true ]
     * @support  int $dresserId 指定的化妆师id require false
     * @support  int $cameramanId 指定的摄影师id require false
     * @support  bool $skipMakeUp 是否跳过化妆 require false
     * @support  int $groupId 分组id require false
     * @support  array $saleSex 到店签到人性别 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userSignIn () {
        return self::getClass()->userSignIn();
    }

    /**
     * 看片签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $retoucherId 指定的看片师id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function retouchSignIn () {
        return self::getClass()->retouchSignIn();
    }

    /**
     * 支持预约看片门店列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewStoreList () {
        return self::getClass()->reviewStoreList();
    }

    /**
     * 获取process信息
     *
     * @param  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  Process\GetProcessInfo\ProcessInfoDTO
     */
    public static function getProcessInfo (int $processId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getProcessInfo([
                            "processId" => $processId,
                        ]),
            "\Mainto\Bridge\Invokes\ProjectPaperless\Manage\Process\GetProcessInfo\ProcessInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}