<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-19 19:40:49
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class UploadRecord
 */
class UploadRecord {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\UploadRecord";

    /**
     * 摄影师中心：搜索订单
     * @return  array
    */
    public static function search (string $orderNo, string $userName, string $userPhone) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->search(["orderNo" => $orderNo, "userName" => $userName, "userPhone" => $userPhone]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\UploadRecord\SearchDTO[]"
        );
    }
    /**
     * 上传记录列表
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\UploadRecord\UploadPageDTO
    */
    public static function uploadList (string $type, string $searchTimeField, string $startTime, string $endTime, string $sortField, string $sort, int $orderId, bool $updatable, bool $todayTakeOrder, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->uploadList(["type" => $type, "searchTimeField" => $searchTimeField, "startTime" => $startTime, "endTime" => $endTime, "sortField" => $sortField, "sort" => $sort, "orderId" => $orderId, "updatable" => $updatable, "todayTakeOrder" => $todayTakeOrder, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\UploadRecord\UploadPageDTO"
        );
    }
    /**
     * 标记退款中不需要处理
     * @return  bool
    */
    public static function tabRefundNotDealWith (int $orderId, int $saleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->tabRefundNotDealWith(["orderId" => $orderId, "saleId" => $saleId]);
    }
    /**
     * 标记订单无需处理
     * @return  bool
    */
    public static function tabOrderUpdateNotDealWith (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->tabOrderUpdateNotDealWith(["orderId" => $orderId]);
    }
    /**
     * 获取各上传总数
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\UploadRecord\VariousUploadedTotalDTO
    */
    public static function variousUploadedTotal (string $type, string $searchTimeField, string $startTime, string $endTime, bool $todayTakeOrder, int $orderId, bool $updatable) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->variousUploadedTotal(["type" => $type, "searchTimeField" => $searchTimeField, "startTime" => $startTime, "endTime" => $endTime, "todayTakeOrder" => $todayTakeOrder, "orderId" => $orderId, "updatable" => $updatable]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\UploadRecord\VariousUploadedTotalDTO"
        );
    }
    /**
     * 上传照片到云端
     * @return  int
    */
    public static function uploadPhotoCloud (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UploadPhotoCloudDto $uploadPhotoCloudDto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadPhotoCloud($uploadPhotoCloudDto);
    }
    /**
     * 异步上传照片到云端
     * @return  int
    */
    public static function uploadPhotoCloudAsync (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UploadPhotoCloudAsyncDto $uploadPhotoCloudAsyncDto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadPhotoCloudAsync($uploadPhotoCloudAsyncDto);
    }
    /**
     * hook照片上传
     * @return  bool
    */
    public static function hookUploadPhoto (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\PhotoInfoDTO $photoInfoDTO) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookUploadPhoto($photoInfoDTO);
    }
    /**
     * 获取订单剩余可传张数
     * @return  array
    */
    public static function getOrderProductUploadedNum (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\OrderProductUploadedNumDTO $orderProductUploadedNumDTO) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderProductUploadedNum($orderProductUploadedNumDTO);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}