<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-21 14:00:42
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SecondRetoucher
 */
class SecondRetoucher {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\SecondRetoucher";

    /**
     * 获取门店待审核数【本门店＋转门店】
     * @return  array
    */
    public static function getWaitReviewCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitReviewCount();
    }
    /**
     * 待审核订单列表
     * @return  array
    */
    public static function getWaitReviewList (string $orderNum, string $search, string $userName, string $userPhone, int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitReviewList(["orderNum" => $orderNum, "search" => $search, "userName" => $userName, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 查询全国待完成订单列表[初始为查询转至本门店订单]
     * @return  array
    */
    public static function queryWaitFinishList (string $orderNum, string $userName, string $userPhone, string $brand = 'himo', string $search, string $wholeOrderNum, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryWaitFinishList(["orderNum" => $orderNum, "userName" => $userName, "userPhone" => $userPhone, "brand" => $brand, "search" => $search, "wholeOrderNum" => $wholeOrderNum, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 我的审核
     * @return  array
    */
    public static function getMyReviewList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMyReviewList();
    }
    /**
     * 提交审核
     * @return  bool
    */
    public static function review (string $streamNum, string $evaluate, array $photo, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->review(["streamNum" => $streamNum, "evaluate" => $evaluate, "photo" => $photo, "note" => $note]);
    }
    /**
     * 获取未读流水
     * @return  int
    */
    public static function getUnreadCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnreadCount();
    }
    /**
     * 查看未读流水
     * @return  bool
    */
    public static function checkUnreadStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUnreadStream();
    }
    /**
     * 提示用户有未完成的订单审核
     * @return  array
    */
    public static function lostOrderNotify () {
        return RpcClass::getClass(self::$serviceName, self::$className)->lostOrderNotify();
    }
    /**
     * 清除未完成的订单列表提示
     * @return  bool
    */
    public static function cleanNotify () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cleanNotify();
    }
    /**
     * 获取在线看片师信息
     * @return  array
    */
    public static function getPictureOnlineRetoucher (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPictureOnlineRetoucher(["staffId" => $staffId]);
    }
    /**
     * 看片审核历史列表
     * @return  array
    */
    public static function reviewHistory (string $orderNum, string $userPhone, string $search, string $userName, string $brand = 'himo', int $page = 1, int $pageSize = 20, bool $searchWithoutStaff, bool $changedStore) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewHistory(["orderNum" => $orderNum, "userPhone" => $userPhone, "search" => $search, "userName" => $userName, "brand" => $brand, "page" => $page, "pageSize" => $pageSize, "searchWithoutStaff" => $searchWithoutStaff, "changedStore" => $changedStore]);
    }
    /**
     * 发送看片通知
     * @return  bool
    */
    public static function sendWatchPhotoNotify (int $orderId, bool $reviewSend = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendWatchPhotoNotify(["orderId" => $orderId, "reviewSend" => $reviewSend]);
    }
    /**
     * 看片通知(bms调用,用于自动看片推送)
     * @return  bool
    */
    public static function autoWatchPhotoNotify (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoWatchPhotoNotify(["orderId" => $orderId]);
    }
    /**
     * 看片退单
     * @return  bool
    */
    public static function reworkStream (string $streamNum, array $photoData, int $assignRetoucherId = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reworkStream(["streamNum" => $streamNum, "photoData" => $photoData, "assignRetoucherId" => $assignRetoucherId]);
    }
    /**
     * 看片师已接订单[取多单]
     * @return  array
    */
    public static function getOrderOnline () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderOnline();
    }
    /**
     * 看片师再来一单
     * @return  bool
    */
    public static function kpsOrderAgain () {
        return RpcClass::getClass(self::$serviceName, self::$className)->kpsOrderAgain();
    }
    /**
     * 绑定审核人id
     * @return  bool
    */
    public static function bindChecker (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindChecker(["orderId" => $orderId]);
    }
    /**
     * 订单详情
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderHistoryInfoDTO
    */
    public static function orderDetail (bool $withRetake, int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderDetail(["withRetake" => $withRetake, "orderId" => $orderId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderHistoryInfoDTO"
        );
    }
    /**
     * 发送授权确认推送
     * @return  bool
    */
    public static function sendNotice (string $orderNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNotice(["orderNum" => $orderNum]);
    }
    /**
     * 获取流水状态
     * @return  array
    */
    public static function getStreamStatus (string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamStatus(["streamNum" => $streamNum]);
    }
    /**
     * 获取产品贴图模板
     * @return  array
    */
    public static function getTemplatesByProductIds (array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplatesByProductIds(["productIds" => $productIds]);
    }
    /**
     * 提交最终成片
     * @return  bool
    */
    public static function submitFinalPhoto (string $streamNum, array $photoData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitFinalPhoto(["streamNum" => $streamNum, "photoData" => $photoData]);
    }
    /**
     * 提交最终成片(异步)
     * @return  bool
    */
    public static function submitFinalPhotoAsync (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\SubmitFinalPhotoAsyncCmd $submitFinalPhotoAsyncCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitFinalPhotoAsync($submitFinalPhotoAsyncCmd);
    }
    /**
     * 摄影师/看片师上传队列上传照片七牛云失败
     * @return  bool
    */
    public static function uploadQiniuErr (int $streamId, string $path) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadQiniuErr(["streamId" => $streamId, "path" => $path]);
    }
    /**
     * hook照片上传
     * @return  bool
    */
    public static function hookUploadPhoto (int $streamId, string $path, int $photoId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookUploadPhoto(["streamId" => $streamId, "path" => $path, "photoId" => $photoId]);
    }
    /**
     * 获取看片师历史上传记录列表
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetHistoryPageDTO
    */
    public static function getHistoryList (string $startTime, string $endTime, string $search, string $orderNum, string $userName, string $userPhone, bool $searchWithoutStaff, bool $changedStore, int $page = 1, int $pageSize = 20) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getHistoryList(["startTime" => $startTime, "endTime" => $endTime, "search" => $search, "orderNum" => $orderNum, "userName" => $userName, "userPhone" => $userPhone, "searchWithoutStaff" => $searchWithoutStaff, "changedStore" => $changedStore, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetHistoryPageDTO"
        );
    }
    /**
     * 系统自动看片设置成片(RPC调用)
     * @return  array
    */
    public static function autoSetFinishedPhoto (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoSetFinishedPhoto(["orderId" => $orderId]);
    }
    /**
     * 清除自动看片完成订单的顾客满意片
     * @return  bool
    */
    public static function clearAutoFinishPhoto (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearAutoFinishPhoto(["orderId" => $orderId]);
    }
    /**
     * 获取看片照片数量,时长,看片通知时间 - bms
     * @return  array
    */
    public static function getLookingPhotoExtendInfo (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLookingPhotoExtendInfo(["orderId" => $orderId]);
    }
    /**
     * 批量获取看片照片数量和时长
     * @return  mixed
    */
    public static function batchLookingPhotoNumbersAndTimes (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchLookingPhotoNumbersAndTimes(["orderIds" => $orderIds]);
    }
    /**
     * 看片排单表可约时间
     * @return  array
    */
    public static function lookList (string $dateStart, string $dateEnd, int $orderId, int $changeStoreId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lookList(["dateStart" => $dateStart, "dateEnd" => $dateEnd, "orderId" => $orderId, "changeStoreId" => $changeStoreId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookListDTO[]"
        );
    }
    /**
     * 添加看片排单表预约
     * @return  bool
    */
    public static function addReservation (int $orderId, string $orderTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addReservation(["orderId" => $orderId, "orderTime" => $orderTime]);
    }
    /**
     * 修改看片预约时间
     * @return  bool
    */
    public static function changeLookPhotoReserveTime (int $orderId, string $lookPhotoReserveTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeLookPhotoReserveTime(["orderId" => $orderId, "lookPhotoReserveTime" => $lookPhotoReserveTime]);
    }
    /**
     * 取消看片预约
     * @return  bool
    */
    public static function cancelLookPhotoReserveTime (int $orderId, string $look_photo_reserve_time) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelLookPhotoReserveTime(["orderId" => $orderId, "look_photo_reserve_time" => $look_photo_reserve_time]);
    }
    /**
     * 预约看片全局订单查询
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\AllOrderPageDTO
    */
    public static function allOrderList (string $orderNo, string $userPhone, int $page, int $pageSize) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allOrderList(["orderNo" => $orderNo, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\AllOrderPageDTO"
        );
    }
    /**
     * 大订单列表
     * @return  array
    */
    public static function bigOrderList (string $dateStart, string $dateEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bigOrderList(["dateStart" => $dateStart, "dateEnd" => $dateEnd]);
    }
    /**
     * 大订单一小时内未预约提示
     * @return  mixed
    */
    public static function delaySendBigOrderNotice (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delaySendBigOrderNotice(["order_id" => $order_id]);
    }
    /**
     * 看片排单表
     * @return  array
    */
    public static function lookingReservation (string $dateStart, string $dateEnd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lookingReservation(["dateStart" => $dateStart, "dateEnd" => $dateEnd]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookingReservationDTO[]"
        );
    }
    /**
     * 看片预约排单表详情
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookReservationDetailDTO
    */
    public static function lookReservationDetail (string $selectDate, int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lookReservationDetail(["selectDate" => $selectDate, "storeId" => $storeId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookReservationDetailDTO"
        );
    }
    /**
     * 调整流水
     * @return  mixed
    */
    public static function cloudStreamTest (int $stream_id, array $raw) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cloudStreamTest(["stream_id" => $stream_id, "raw" => $raw]);
    }
    /**
     * 订单退回等待看片
     * @return  bool
    */
    public static function backWaitLooking (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitLooking(["orderId" => $orderId]);
    }
    /**
     * 通过订单ids获取看片预约时间
     * @return  mixed
    */
    public static function getOrdersEstimateTime (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrdersEstimateTime(["orderIds" => $orderIds]);
    }
    /**
     * 获取已完成看片的productIds
     * @return  array
    */
    public static function getCompleteLookPhotoProductIds (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCompleteLookPhotoProductIds(["orderId" => $orderId]);
    }
    /**
     * 获取同品牌、同价格区 已上线门店
     * @return  array
    */
    public static function getSameStore () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSameStore();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}