<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-21 14:00:42
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\Order";

    /**
     * 订单列表
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Order\OrderListPageDTO
    */
    public static function list (string $userPhone, string $userName, string $orderNo, string $status, int $storeId, int $page, string $sortField, bool $sortDesc, string $module, int $pageSize, string $searchField, string $startTime, string $endTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list(["userPhone" => $userPhone, "userName" => $userName, "orderNo" => $orderNo, "status" => $status, "storeId" => $storeId, "page" => $page, "sortField" => $sortField, "sortDesc" => $sortDesc, "module" => $module, "pageSize" => $pageSize, "searchField" => $searchField, "startTime" => $startTime, "endTime" => $endTime]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Order\OrderListPageDTO"
        );
    }
    /**
     * 无纸化订单列表
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\PaperlessOrderPageDTO
    */
    public static function paperlessOrders (string $userPhone, string $userName, string $orderNo, string $stage, int $storeId, bool $isPrinted, bool $isPosted, int $page, int $pageSize, string $searchField, string $startTime, string $endTime) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->paperlessOrders(["userPhone" => $userPhone, "userName" => $userName, "orderNo" => $orderNo, "stage" => $stage, "storeId" => $storeId, "isPrinted" => $isPrinted, "isPosted" => $isPosted, "page" => $page, "pageSize" => $pageSize, "searchField" => $searchField, "startTime" => $startTime, "endTime" => $endTime]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\PaperlessOrderPageDTO"
        );
    }
    /**
     * 更新订单备注信息
     * @return  bool
    */
    public static function saveNote (int $orderId, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveNote(["orderId" => $orderId, "note" => $note]);
    }
    /**
     * 拍摄状态数量统计
     * @return  array
    */
    public static function getOrderStageNums (string $userPhone, string $userName, string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderStageNums(["userPhone" => $userPhone, "userName" => $userName, "orderNo" => $orderNo]);
    }
    /**
     * 获取订单的协作分配信息
     * @return  array
    */
    public static function getMakeUpAssignStaffs () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMakeUpAssignStaffs(),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\ProcessAssistantPeopleDTO[]"
        );
    }
    /**
     * 获取订单的协作工作量信息
     * @return  array
    */
    public static function getAssignWorkloads (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\OrderAssignWorkloadCmd $orderAssignWorkloadCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAssignWorkloads($orderAssignWorkloadCmd);
    }
    /**
     * 指定订单接单伙伴
     * @return  bool
    */
    public static function assignStageStaff (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\AssignStageStaffCmd $assignStageStaffCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->assignStageStaff($assignStageStaffCmd);
    }
    /**
     * 清除订单接单伙伴
     * @return  bool
    */
    public static function cancelAssignStageStaff (int $orderId, string $stage) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAssignStageStaff(["orderId" => $orderId, "stage" => $stage]);
    }
    /**
     * 挂起订单
     * @return  bool
    */
    public static function hang (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hang(["orderId" => $orderId]);
    }
    /**
     * 取消挂起订单
     * @return  bool
    */
    public static function cancelHang (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelHang(["orderId" => $orderId]);
    }
    /**
     * 更换伙伴
     * @return  bool
    */
    public static function changeStaff (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\ChangeStaffCmd $changeStaffCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeStaff($changeStaffCmd);
    }
    /**
     * 化妆阶段更换伙伴
     * @return  bool
    */
    public static function makeUpChangeStaff (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\MakeUpChangeStaffCmd $makeUpChangeStaffCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->makeUpChangeStaff($makeUpChangeStaffCmd);
    }
    /**
     * 取消协作
     * @return  bool
    */
    public static function cancelAssist (int $processId, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelAssist(["processId" => $processId, "staffId" => $staffId]);
    }
    /**
     * 更新接单顺序
     * @return  bool
    */
    public static function updateSort (int $orderId, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateSort(["orderId" => $orderId, "sort" => $sort]);
    }
    /**
     * 获取订单可接单伙伴ids
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\CanTakeOrderStaffDTO
    */
    public static function getCanTakeOrderStaffIds (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCanTakeOrderStaffIds(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\CanTakeOrderStaffDTO"
        );
    }
    /**
     * 退回至等待摄影
     * @return  bool
    */
    public static function backWaitPhotography (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitPhotography(["orderId" => $orderId]);
    }
    /**
     * 退回至等待化妆
     * @return  bool
    */
    public static function backWaitMakeUp (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitMakeUp(["orderId" => $orderId]);
    }
    /**
     * 退回至看片排队中
     * @return  bool
    */
    public static function backWaitLookPhoto (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitLookPhoto(["orderId" => $orderId]);
    }
    /**
     * 订单中是否存在已下架产品
     * @return  bool
    */
    public static function hasOffProducts (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasOffProducts(["orderId" => $orderId]);
    }
    /**
     * 获取订单的伙伴列表
     * @return  array
    */
    public static function getStageStaffs (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStageStaffs(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\StageStaffsDTO[]"
        );
    }
    /**
     * 是否是大订单
     * @return  bool
    */
    public static function bigOrder (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bigOrder(["orderId" => $orderId]);
    }
    /**
     * 获取订单预指派的伙伴信息
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\OrderPreAssignStaffsDTO
    */
    public static function getOrderPreAssignStaffs (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderPreAssignStaffs(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\OrderPreAssignStaffsDTO"
        );
    }
    /**
     * 获取订单当前指派的伙伴信息
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\OrderPreAssignStaffsDTO
    */
    public static function getOrderCurrentAssignStaffs (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderCurrentAssignStaffs(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PaperlessOrder\OrderPreAssignStaffsDTO"
        );
    }
    /**
     * 检查是否需要走钉钉无纸化（兼容family合并后部分老kids门店不走钉钉无纸化）
     * @return  bool
    */
    public static function checkNeedPaperless (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkNeedPaperless(["storeId" => $storeId]);
    }
    /**
     * 更新缦图摄影订单额外信息
     * @return  bool
    */
    public static function maintoPhotographyExtendInfo (\Mainto\Bridge\Structs\ProjectPaperless\Order\MaintoPhotograpy\Dto\ExtendInfoDto $extendInfoDto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->maintoPhotographyExtendInfo($extendInfoDto);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}