<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-23 18:09:02
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Logistics
 */
class Logistics {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\Logistics";

    /**
     * 运送工厂制作
     * @return  bool
    */
    public static function factoryProduction (\Mainto\Bridge\Structs\ProjectPaperless\Logistics\DTO\FactoryProductionDto $factoryProductionDto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->factoryProduction($factoryProductionDto);
    }
    /**
     * 保存物流信息
     * @return  mixed
    */
    public static function saveLogisticsInformation (\Mainto\Bridge\Structs\ProjectPaperless\Logistics\DTO\LogisticsInformationDto $logisticsInformationDto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveLogisticsInformation($logisticsInformationDto);
    }
    /**
     * 物流开始寄送
     * @return  bool
    */
    public static function beginTransit (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->beginTransit(["orderId" => $orderId]);
    }
    /**
     * 物流签收
     * @return  bool
    */
    public static function delivery (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delivery(["orderId" => $orderId]);
    }
    /**
     * 物流详情
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Logistics\Mapper\DetailDto
    */
    public static function detail (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Logistics\Mapper\DetailDto"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}