<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method launchDetailByParams(array|OrderAfterSale\LaunchDetail\LaunchDto $params)
 * @method createByParams(array|OrderAfterSale\Create\CreateAfterSaleDto $params)
 * @method terminateApplyByParams(array|OrderAfterSale\TerminateApply\TerminateApplyDto $params)
 */
class OrderAfterSale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取二次看片售后订单详情
     *
     * @var  OrderAfterSale\LaunchDetail\LaunchDto $dto $dto
     * @throws  \Exception
     * @return  OrderAfterSale\LaunchDetail\LaunchResDto
     */
    public static function launchDetail (OrderAfterSale\LaunchDetail\LaunchDto $dto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->launchDetail($dto),
            "\Mainto\Bridge\Invokes\ProjectPaperless\Manage\OrderAfterSale\LaunchDetail\LaunchResDto"
        );
    }


    /**
     * 创建二次看片
     *
     * @var  OrderAfterSale\Create\CreateAfterSaleDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function create (OrderAfterSale\Create\CreateAfterSaleDto $dto) {
        return self::getClass()->create($dto);
    }


    /**
     * 取消售后单
     *
     * @var  OrderAfterSale\TerminateApply\TerminateApplyDto $dto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function terminateApply (OrderAfterSale\TerminateApply\TerminateApplyDto $dto) {
        return self::getClass()->terminateApply($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\OrderAfterSale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\OrderAfterSale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}